package drr.projection.dtcc.rds.harmonized.cftc.rewrite.trade.functions;

import cdm.base.staticdata.asset.common.AssetClassEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.cftc.rewrite.dtcc.DTCCAdditionalFields;
import drr.regulation.cftc.rewrite.trade.CFTCTransactionReport;
import drr.regulation.common.trade.CommonLeg;
import drr.standards.iosco.cde.base.payment.OtherPayment;
import drr.standards.iosco.cde.base.price.PriceFormat;
import drr.standards.iso.PaymentType4Code;
import java.math.BigDecimal;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(RequiresUpFrontFeeProjection.RequiresUpFrontFeeProjectionDefault.class)
public abstract class RequiresUpFrontFeeProjection implements RosettaFunction {

	/**
	* @param drrReport 
	* @return result 
	*/
	public Boolean evaluate(CFTCTransactionReport drrReport) {
		Boolean result = doEvaluate(drrReport);
		
		return result;
	}

	protected abstract Boolean doEvaluate(CFTCTransactionReport drrReport);

	public static class RequiresUpFrontFeeProjectionDefault extends RequiresUpFrontFeeProjection {
		@Override
		protected Boolean doEvaluate(CFTCTransactionReport drrReport) {
			Boolean result = null;
			return assignOutput(result, drrReport);
		}
		
		protected Boolean assignOutput(Boolean result, CFTCTransactionReport drrReport) {
			result = notExists(MapperS.of(drrReport).<OtherPayment>mapC("getOtherPayment", cFTCTransactionReport -> cFTCTransactionReport.getOtherPayment()).<PaymentType4Code>map("getPaymentType", otherPayment -> otherPayment.getPaymentType())).and(areEqual(MapperS.of(drrReport).<DTCCAdditionalFields>map("getDtccAdditionalFields", cFTCTransactionReport -> cFTCTransactionReport.getDtccAdditionalFields()).<AssetClassEnum>map("getPrimaryAssetClass", dTCCAdditionalFields -> dTCCAdditionalFields.getPrimaryAssetClass()), MapperS.of(AssetClassEnum.CREDIT), CardinalityOperator.All)).and(notExists(MapperS.of(drrReport).<CommonLeg>map("getLeg1", cFTCTransactionReport -> cFTCTransactionReport.getLeg1()).<BigDecimal>map("getFixedRate", commonLeg -> commonLeg.getFixedRate()))).and(notExists(MapperS.of(drrReport).<CommonLeg>map("getLeg1", cFTCTransactionReport -> cFTCTransactionReport.getLeg1()).<PriceFormat>map("getSpread", commonLeg -> commonLeg.getSpread()))).get();
			
			return result;
		}
	}
}
