package drr.projection.dtcc.rds.harmonized.csa.rewrite.trade.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RuneLabelProvider;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import drr.projection.dtcc.rds.harmonized.csa.rewrite.trade.labels.Project_CSATradeReportToDtccRdsHarmonizedLabelProvider;
import drr.regulation.csa.rewrite.trade.CSATransactionReport;
import iso20022.dtcc.rds.harmonized.Document;
import java.util.Optional;
import javax.inject.Inject;


@RuneLabelProvider(labelProvider=Project_CSATradeReportToDtccRdsHarmonizedLabelProvider.class)
@ImplementedBy(Project_CSATradeReportToDtccRdsHarmonized.Project_CSATradeReportToDtccRdsHarmonizedDefault.class)
public abstract class Project_CSATradeReportToDtccRdsHarmonized implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected Create_SubmissionCore create_SubmissionCore;
	@Inject protected Create_SubmissionHarmonizedData create_SubmissionHarmonizedData;
	@Inject protected Create_SubmissionHarmonizedRepeatableData create_SubmissionHarmonizedRepeatableData;
	@Inject protected Create_SubmissionHeader create_SubmissionHeader;
	@Inject protected Create_SubmissionSchedules create_SubmissionSchedules;

	/**
	* @param drrReport 
	* @return harmonizedReport 
	*/
	public Document evaluate(CSATransactionReport drrReport) {
		Document.DocumentBuilder harmonizedReportBuilder = doEvaluate(drrReport);
		
		final Document harmonizedReport;
		if (harmonizedReportBuilder == null) {
			harmonizedReport = null;
		} else {
			harmonizedReport = harmonizedReportBuilder.build();
			objectValidator.validate(Document.class, harmonizedReport);
		}
		
		return harmonizedReport;
	}

	protected abstract Document.DocumentBuilder doEvaluate(CSATransactionReport drrReport);

	public static class Project_CSATradeReportToDtccRdsHarmonizedDefault extends Project_CSATradeReportToDtccRdsHarmonized {
		@Override
		protected Document.DocumentBuilder doEvaluate(CSATransactionReport drrReport) {
			Document.DocumentBuilder harmonizedReport = Document.builder();
			return assignOutput(harmonizedReport, drrReport);
		}
		
		protected Document.DocumentBuilder assignOutput(Document.DocumentBuilder harmonizedReport, CSATransactionReport drrReport) {
			harmonizedReport
				.getOrCreateSubmission()
				.setHeader(create_SubmissionHeader.evaluate(drrReport));
			
			harmonizedReport
				.getOrCreateSubmission()
				.setCore(create_SubmissionCore.evaluate(drrReport));
			
			harmonizedReport
				.getOrCreateSubmission()
				.setHarmonizedData(create_SubmissionHarmonizedData.evaluate(drrReport));
			
			harmonizedReport
				.getOrCreateSubmission()
				.setHarmonizedRepeatableData(create_SubmissionHarmonizedRepeatableData.evaluate(drrReport));
			
			harmonizedReport
				.getOrCreateSubmission()
				.setSchedules(create_SubmissionSchedules.evaluate(drrReport));
			
			return Optional.ofNullable(harmonizedReport)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
