package drr.projection.iso20022.jfsa.rewrite.margin.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.functions.IsMax32UpperCaseAlphanumericText;
import drr.regulation.jfsa.rewrite.margin.CollateralReport;
import drr.regulation.jfsa.rewrite.margin.PartiesToTheDerivative;
import drr.standards.iso.CollateralisationType3Code__1;
import iso20022.auth108.jfsa.CollateralPortfolioCode6Choice__1;
import iso20022.auth108.jfsa.CollateralisationType3Code;
import iso20022.auth108.jfsa.GenericIdentification175__1;
import iso20022.auth108.jfsa.MarginCollateralReport5__1;
import iso20022.auth108.jfsa.MarginPortfolio4__1;
import iso20022.auth108.jfsa.MarginReportData9__1;
import iso20022.auth108.jfsa.NotApplicable1Code;
import iso20022.auth108.jfsa.PortfolioCode5Choice__1;
import iso20022.auth108.jfsa.PortfolioIdentification3__1;
import iso20022.auth108.jfsa.TechnicalAttributes6__1;
import iso20022.auth108.jfsa.UniqueTransactionIdentifier2Choice__1;
import java.time.ZonedDateTime;
import java.util.Optional;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(Create_MarginReportData.Create_MarginReportDataDefault.class)
public abstract class Create_MarginReportData implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected Create_CounterpartySpecificData create_CounterpartySpecificData;
	@Inject protected Create_PostedMarginReport create_PostedMarginReport;
	@Inject protected Create_ReceivedMarginReport create_ReceivedMarginReport;
	@Inject protected IsMax32UpperCaseAlphanumericText isMax32UpperCaseAlphanumericText;

	/**
	* @param partiesToTheDerivative 
	* @param collateralReport 
	* @return details 
	*/
	public MarginReportData9__1 evaluate(PartiesToTheDerivative partiesToTheDerivative, CollateralReport collateralReport) {
		MarginReportData9__1.MarginReportData9__1Builder detailsBuilder = doEvaluate(partiesToTheDerivative, collateralReport);
		
		final MarginReportData9__1 details;
		if (detailsBuilder == null) {
			details = null;
		} else {
			details = detailsBuilder.build();
			objectValidator.validate(MarginReportData9__1.class, details);
		}
		
		return details;
	}

	protected abstract MarginReportData9__1.MarginReportData9__1Builder doEvaluate(PartiesToTheDerivative partiesToTheDerivative, CollateralReport collateralReport);

	public static class Create_MarginReportDataDefault extends Create_MarginReportData {
		@Override
		protected MarginReportData9__1.MarginReportData9__1Builder doEvaluate(PartiesToTheDerivative partiesToTheDerivative, CollateralReport collateralReport) {
			MarginReportData9__1.MarginReportData9__1Builder details = MarginReportData9__1.builder();
			return assignOutput(details, partiesToTheDerivative, collateralReport);
		}
		
		protected MarginReportData9__1.MarginReportData9__1Builder assignOutput(MarginReportData9__1.MarginReportData9__1Builder details, PartiesToTheDerivative partiesToTheDerivative, CollateralReport collateralReport) {
			final Boolean _boolean = isMax32UpperCaseAlphanumericText.evaluate(MapperS.of(collateralReport).<String>map("getUti", _collateralReport -> _collateralReport.getUti()).get());
			String ifThenElseResult0 = null;
			if ((_boolean == null ? false : _boolean)) {
				ifThenElseResult0 = MapperS.of(collateralReport).<String>map("getUti", _collateralReport -> _collateralReport.getUti()).get();
			}
			GenericIdentification175__1 ifThenElseResult1 = null;
			if (areEqual(MapperS.of(isMax32UpperCaseAlphanumericText.evaluate(MapperS.of(collateralReport).<String>map("getUti", _collateralReport -> _collateralReport.getUti()).get())), MapperS.of(false), CardinalityOperator.All).getOrDefault(false)) {
				ifThenElseResult1 = GenericIdentification175__1.builder()
					.setId(MapperS.of(collateralReport).<String>map("getUti", _collateralReport -> _collateralReport.getUti()).get())
					.build();
			}
			String ifThenElseResult2 = null;
			if (exists(MapperS.of(collateralReport).<String>map("getInitialMarginCollateralPortfolioCode", _collateralReport -> _collateralReport.getInitialMarginCollateralPortfolioCode())).getOrDefault(false)) {
				ifThenElseResult2 = MapperS.of(collateralReport).<String>map("getInitialMarginCollateralPortfolioCode", _collateralReport -> _collateralReport.getInitialMarginCollateralPortfolioCode()).get();
			}
			NotApplicable1Code ifThenElseResult3 = null;
			if (notExists(MapperS.of(collateralReport).<String>map("getInitialMarginCollateralPortfolioCode", _collateralReport -> _collateralReport.getInitialMarginCollateralPortfolioCode())).getOrDefault(false)) {
				ifThenElseResult3 = NotApplicable1Code.NOAP;
			}
			String ifThenElseResult4 = null;
			if (exists(MapperS.of(collateralReport).<String>map("getVariationMarginCollateralPortfolioCode", _collateralReport -> _collateralReport.getVariationMarginCollateralPortfolioCode())).getOrDefault(false)) {
				ifThenElseResult4 = MapperS.of(collateralReport).<String>map("getVariationMarginCollateralPortfolioCode", _collateralReport -> _collateralReport.getVariationMarginCollateralPortfolioCode()).get();
			}
			NotApplicable1Code ifThenElseResult5 = null;
			if (notExists(MapperS.of(collateralReport).<String>map("getVariationMarginCollateralPortfolioCode", _collateralReport -> _collateralReport.getVariationMarginCollateralPortfolioCode())).getOrDefault(false)) {
				ifThenElseResult5 = NotApplicable1Code.NOAP;
			}
			details = toBuilder(MarginReportData9__1.builder()
				.setRptgTmStmp(MapperS.of(partiesToTheDerivative).<ZonedDateTime>map("getReportingTimestamp", _partiesToTheDerivative -> _partiesToTheDerivative.getReportingTimestamp()).get())
				.setTxId(UniqueTransactionIdentifier2Choice__1.builder()
					.setUnqTxIdr(ifThenElseResult0)
					.setPrtry(ifThenElseResult1)
					.build())
				.setCtrPtyId(create_CounterpartySpecificData.evaluate(partiesToTheDerivative, collateralReport))
				.setColl(MarginCollateralReport5__1.builder()
					.setCollstnCtgy(MapperS.of(collateralReport).<CollateralisationType3Code__1>map("getCollateralisationCategory", _collateralReport -> _collateralReport.getCollateralisationCategory()).checkedMap("to-enum", e -> CollateralisationType3Code.valueOf(e.name()), IllegalArgumentException.class).get())
					.setCollPrtflCd(CollateralPortfolioCode6Choice__1.builder()
						.setMrgnPrtflCd(MarginPortfolio4__1.builder()
							.setInitlMrgnPrtflCd(PortfolioCode5Choice__1.builder()
								.setPrtfl(PortfolioIdentification3__1.builder()
									.setCd(ifThenElseResult2)
									.build())
								.setNoPrtfl(ifThenElseResult3)
								.build())
							.setVartnMrgnPrtflCd(PortfolioCode5Choice__1.builder()
								.setPrtfl(PortfolioIdentification3__1.builder()
									.setCd(ifThenElseResult4)
									.build())
								.setNoPrtfl(ifThenElseResult5)
								.build())
							.build())
						.build())
					.setTmStmp(MapperS.of(collateralReport).<ZonedDateTime>map("getEventTimestamp", _collateralReport -> _collateralReport.getEventTimestamp()).get())
					.build())
				.setPstdMrgnOrColl(create_PostedMarginReport.evaluate(collateralReport))
				.setRcvdMrgnOrColl(create_ReceivedMarginReport.evaluate(collateralReport))
				.setTechAttrbts(TechnicalAttributes6__1.builder()
					.setTechRcrdId(MapperS.of(collateralReport).<String>map("getTechnicalRecordId", _collateralReport -> _collateralReport.getTechnicalRecordId()).get())
					.build())
				.build());
			
			return Optional.ofNullable(details)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
