package drr.regulation.asic.rewrite.margin.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.asic.rewrite.margin.ASICMarginReport;
import drr.regulation.common.MarginActionEnum;
import drr.standards.iso.CollateralisationType3Code__1;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 6.17.7
 */
@RosettaDataRule("ASICMarginReportDTCC_ASIC_BR_3013_01")
@ImplementedBy(ASICMarginReportDTCC_ASIC_BR_3013_01.Default.class)
public interface ASICMarginReportDTCC_ASIC_BR_3013_01 extends Validator<ASICMarginReport> {
	
	String NAME = "ASICMarginReportDTCC_ASIC_BR_3013_01";
	String DEFINITION = "if actionType = MarginActionEnum -> MARU or actionType = MarginActionEnum -> CORR then if collateralisationCategory = CollateralisationType3Code__1 -> OWC1 or collateralisationCategory = CollateralisationType3Code__1 -> OWP1 or collateralisationCategory = CollateralisationType3Code__1 -> FLCL then initialMarginCollectedByTheReportingEntityPostHaircut exists and initialMarginCollectedByTheReportingEntityPostHaircut >= 0 else initialMarginCollectedByTheReportingEntityPostHaircut is absent";
	
	class Default implements ASICMarginReportDTCC_ASIC_BR_3013_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, ASICMarginReport aSICMarginReport) {
			ComparisonResult result = executeDataRule(aSICMarginReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "ASICMarginReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "ASICMarginReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(ASICMarginReport aSICMarginReport) {
			try {
				if (areEqual(MapperS.of(aSICMarginReport).<MarginActionEnum>map("getActionType", _aSICMarginReport -> _aSICMarginReport.getActionType()), MapperS.of(MarginActionEnum.MARU), CardinalityOperator.All).or(areEqual(MapperS.of(aSICMarginReport).<MarginActionEnum>map("getActionType", _aSICMarginReport -> _aSICMarginReport.getActionType()), MapperS.of(MarginActionEnum.CORR), CardinalityOperator.All)).getOrDefault(false)) {
					if (areEqual(MapperS.of(aSICMarginReport).<CollateralisationType3Code__1>map("getCollateralisationCategory", _aSICMarginReport -> _aSICMarginReport.getCollateralisationCategory()), MapperS.of(CollateralisationType3Code__1.OWC1), CardinalityOperator.All).or(areEqual(MapperS.of(aSICMarginReport).<CollateralisationType3Code__1>map("getCollateralisationCategory", _aSICMarginReport -> _aSICMarginReport.getCollateralisationCategory()), MapperS.of(CollateralisationType3Code__1.OWP1), CardinalityOperator.All)).or(areEqual(MapperS.of(aSICMarginReport).<CollateralisationType3Code__1>map("getCollateralisationCategory", _aSICMarginReport -> _aSICMarginReport.getCollateralisationCategory()), MapperS.of(CollateralisationType3Code__1.FLCL), CardinalityOperator.All)).getOrDefault(false)) {
						return exists(MapperS.of(aSICMarginReport).<BigDecimal>map("getInitialMarginCollectedByTheReportingEntityPostHaircut", _aSICMarginReport -> _aSICMarginReport.getInitialMarginCollectedByTheReportingEntityPostHaircut())).and(greaterThanEquals(MapperS.of(aSICMarginReport).<BigDecimal>map("getInitialMarginCollectedByTheReportingEntityPostHaircut", _aSICMarginReport -> _aSICMarginReport.getInitialMarginCollectedByTheReportingEntityPostHaircut()), MapperS.of(BigDecimal.valueOf(0)), CardinalityOperator.All));
					}
					return notExists(MapperS.of(aSICMarginReport).<BigDecimal>map("getInitialMarginCollectedByTheReportingEntityPostHaircut", _aSICMarginReport -> _aSICMarginReport.getInitialMarginCollectedByTheReportingEntityPostHaircut()));
				}
				return ComparisonResult.successEmptyOperand("");
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements ASICMarginReportDTCC_ASIC_BR_3013_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, ASICMarginReport aSICMarginReport) {
			return Collections.emptyList();
		}
	}
}
