package drr.regulation.cftc.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.cftc.rewrite.functions.ValidatePartyIdentifierFormat;
import drr.regulation.cftc.rewrite.trade.CFTCPart43TransactionReport;
import drr.regulation.common.PartyIdentifierFormatEnum;
import drr.regulation.common.util.functions.EmptyOrAllMatch;
import drr.standards.iosco.cde.base.payment.OtherPayment;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;


/**
 * @version 6.17.7
 */
@RosettaDataRule("CFTCPart43TransactionReportOtherPartyPaymentPayerIdentifierFormat")
@ImplementedBy(CFTCPart43TransactionReportOtherPartyPaymentPayerIdentifierFormat.Default.class)
public interface CFTCPart43TransactionReportOtherPartyPaymentPayerIdentifierFormat extends Validator<CFTCPart43TransactionReport> {
	
	String NAME = "CFTCPart43TransactionReportOtherPartyPaymentPayerIdentifierFormat";
	String DEFINITION = "EmptyOrAllMatch( otherPayment extract ValidatePartyIdentifierFormat(payer, payerFormat), True )";
	
	class Default implements CFTCPart43TransactionReportOtherPartyPaymentPayerIdentifierFormat {
	
		@Inject protected EmptyOrAllMatch emptyOrAllMatch;
		
		@Inject protected ValidatePartyIdentifierFormat validatePartyIdentifierFormat;
		
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart43TransactionReport cFTCPart43TransactionReport) {
			ComparisonResult result = executeDataRule(cFTCPart43TransactionReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "CFTCPart43TransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "CFTCPart43TransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(CFTCPart43TransactionReport cFTCPart43TransactionReport) {
			try {
				return ComparisonResult.of(MapperS.of(emptyOrAllMatch.evaluate(MapperS.of(cFTCPart43TransactionReport).<OtherPayment>mapC("getOtherPayment", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getOtherPayment())
					.mapItem(item -> MapperS.of(validatePartyIdentifierFormat.evaluate(item.<String>map("getPayer", otherPayment -> otherPayment.getPayer()).get(), item.<PartyIdentifierFormatEnum>map("getPayerFormat", otherPayment -> otherPayment.getPayerFormat()).get()))).getMulti(), true)));
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements CFTCPart43TransactionReportOtherPartyPaymentPayerIdentifierFormat {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart43TransactionReport cFTCPart43TransactionReport) {
			return Collections.emptyList();
		}
	}
}
