package drr.regulation.common.functions;

import cdm.base.staticdata.asset.common.ProductIdTypeEnum;
import cdm.base.staticdata.asset.common.ProductIdentifier;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(GetProductIdentifierFilteringISIN.GetProductIdentifierFilteringISINDefault.class)
public abstract class GetProductIdentifierFilteringISIN implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;

	/**
	* @param productIdentifiers List of product identifiers
	* @return productIdentifier Single product identifier
	*/
	public ProductIdentifier evaluate(List<? extends ProductIdentifier> productIdentifiers) {
		ProductIdentifier.ProductIdentifierBuilder productIdentifierBuilder = doEvaluate(productIdentifiers);
		
		final ProductIdentifier productIdentifier;
		if (productIdentifierBuilder == null) {
			productIdentifier = null;
		} else {
			productIdentifier = productIdentifierBuilder.build();
			objectValidator.validate(ProductIdentifier.class, productIdentifier);
		}
		
		return productIdentifier;
	}

	protected abstract ProductIdentifier.ProductIdentifierBuilder doEvaluate(List<? extends ProductIdentifier> productIdentifiers);

	public static class GetProductIdentifierFilteringISINDefault extends GetProductIdentifierFilteringISIN {
		@Override
		protected ProductIdentifier.ProductIdentifierBuilder doEvaluate(List<? extends ProductIdentifier> productIdentifiers) {
			if (productIdentifiers == null) {
				productIdentifiers = Collections.emptyList();
			}
			ProductIdentifier.ProductIdentifierBuilder productIdentifier = ProductIdentifier.builder();
			return assignOutput(productIdentifier, productIdentifiers);
		}
		
		protected ProductIdentifier.ProductIdentifierBuilder assignOutput(ProductIdentifier.ProductIdentifierBuilder productIdentifier, List<? extends ProductIdentifier> productIdentifiers) {
			if (areEqual(MapperC.<ProductIdentifier>of(productIdentifiers).<ProductIdTypeEnum>map("getSource", _productIdentifier -> _productIdentifier.getSource()), MapperS.of(ProductIdTypeEnum.ISIN), CardinalityOperator.Any).getOrDefault(false)) {
				final MapperC<ProductIdentifier> thenArg = MapperC.<ProductIdentifier>of(productIdentifiers)
					.filterItemNullSafe(item -> areEqual(item.<ProductIdTypeEnum>map("getSource", _productIdentifier -> _productIdentifier.getSource()), MapperS.of(ProductIdTypeEnum.ISIN), CardinalityOperator.All).get());
				productIdentifier = toBuilder(thenArg
					.first().get());
			} else {
				productIdentifier = toBuilder(MapperC.<ProductIdentifier>of(productIdentifiers)
					.first().get());
			}
			
			return Optional.ofNullable(productIdentifier)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
