package drr.regulation.common.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.ReportableActionEnum;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.ReportableInformation;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(IsActionTypePRTO.IsActionTypePRTODefault.class)
public abstract class IsActionTypePRTO implements RosettaFunction {

	/**
	* @param reportableEvent 
	* @return isActionTypePrto 
	*/
	public Boolean evaluate(ReportableEvent reportableEvent) {
		Boolean isActionTypePrto = doEvaluate(reportableEvent);
		
		return isActionTypePrto;
	}

	protected abstract Boolean doEvaluate(ReportableEvent reportableEvent);

	protected abstract MapperS<ReportableActionEnum> action(ReportableEvent reportableEvent);

	public static class IsActionTypePRTODefault extends IsActionTypePRTO {
		@Override
		protected Boolean doEvaluate(ReportableEvent reportableEvent) {
			Boolean isActionTypePrto = null;
			return assignOutput(isActionTypePrto, reportableEvent);
		}
		
		protected Boolean assignOutput(Boolean isActionTypePrto, ReportableEvent reportableEvent) {
			isActionTypePrto = exists(action(reportableEvent)).and(areEqual(action(reportableEvent), MapperS.of(ReportableActionEnum.TRANSFER_OUT), CardinalityOperator.All)).get();
			
			return isActionTypePrto;
		}
		
		@Override
		protected MapperS<ReportableActionEnum> action(ReportableEvent reportableEvent) {
			return MapperS.of(reportableEvent).<ReportableInformation>map("getReportableInformation", _reportableEvent -> _reportableEvent.getReportableInformation()).<ReportableActionEnum>map("getReportableAction", reportableInformation -> reportableInformation.getReportableAction());
		}
	}
}
