package drr.regulation.common.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.ReportableActionEnum;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.ReportableInformation;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(IsActionTypeREVI.IsActionTypeREVIDefault.class)
public abstract class IsActionTypeREVI implements RosettaFunction {

	/**
	* @param reportableEvent 
	* @return isActionTypeRevi 
	*/
	public Boolean evaluate(ReportableEvent reportableEvent) {
		Boolean isActionTypeRevi = doEvaluate(reportableEvent);
		
		return isActionTypeRevi;
	}

	protected abstract Boolean doEvaluate(ReportableEvent reportableEvent);

	protected abstract MapperS<ReportableActionEnum> action(ReportableEvent reportableEvent);

	public static class IsActionTypeREVIDefault extends IsActionTypeREVI {
		@Override
		protected Boolean doEvaluate(ReportableEvent reportableEvent) {
			Boolean isActionTypeRevi = null;
			return assignOutput(isActionTypeRevi, reportableEvent);
		}
		
		protected Boolean assignOutput(Boolean isActionTypeRevi, ReportableEvent reportableEvent) {
			isActionTypeRevi = exists(action(reportableEvent)).and(areEqual(action(reportableEvent), MapperS.of(ReportableActionEnum.REVIVE), CardinalityOperator.All)).get();
			
			return isActionTypeRevi;
		}
		
		@Override
		protected MapperS<ReportableActionEnum> action(ReportableEvent reportableEvent) {
			return MapperS.of(reportableEvent).<ReportableInformation>map("getReportableInformation", _reportableEvent -> _reportableEvent.getReportableInformation()).<ReportableActionEnum>map("getReportableAction", reportableInformation -> reportableInformation.getReportableAction());
		}
	}
}
