package drr.regulation.common.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.ReportableActionEnum;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.ReportableInformation;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(IsEventTypePTNG.IsEventTypePTNGDefault.class)
public abstract class IsEventTypePTNG implements RosettaFunction {

	/**
	* @param reportableEvent 
	* @return isEventTypePtng 
	*/
	public Boolean evaluate(ReportableEvent reportableEvent) {
		Boolean isEventTypePtng = doEvaluate(reportableEvent);
		
		return isEventTypePtng;
	}

	protected abstract Boolean doEvaluate(ReportableEvent reportableEvent);

	protected abstract MapperS<ReportableActionEnum> event(ReportableEvent reportableEvent);

	public static class IsEventTypePTNGDefault extends IsEventTypePTNG {
		@Override
		protected Boolean doEvaluate(ReportableEvent reportableEvent) {
			Boolean isEventTypePtng = null;
			return assignOutput(isEventTypePtng, reportableEvent);
		}
		
		protected Boolean assignOutput(Boolean isEventTypePtng, ReportableEvent reportableEvent) {
			isEventTypePtng = exists(event(reportableEvent)).and(areEqual(event(reportableEvent), MapperS.of(ReportableActionEnum.TRANSFER_IN), CardinalityOperator.All)).get();
			
			return isEventTypePtng;
		}
		
		@Override
		protected MapperS<ReportableActionEnum> event(ReportableEvent reportableEvent) {
			return MapperS.of(reportableEvent).<ReportableInformation>map("getReportableInformation", _reportableEvent -> _reportableEvent.getReportableInformation()).<ReportableActionEnum>map("getReportableAction", reportableInformation -> reportableInformation.getReportableAction());
		}
	}
}
