package drr.regulation.common.functions;

import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(IsFixedFloatZeroCouponSwapKnownAmount.IsFixedFloatZeroCouponSwapKnownAmountDefault.class)
public abstract class IsFixedFloatZeroCouponSwapKnownAmount implements RosettaFunction {
	
	// RosettaFunction dependencies
	//
	@Inject protected InterestRateLeg1ZeroCouponSwapKnownAmount interestRateLeg1ZeroCouponSwapKnownAmount;
	@Inject protected IsFixedFloatZeroCouponSwap isFixedFloatZeroCouponSwap;

	/**
	* @param product 
	* @return result 
	*/
	public Boolean evaluate(Product product) {
		Boolean result = doEvaluate(product);
		
		return result;
	}

	protected abstract Boolean doEvaluate(Product product);

	public static class IsFixedFloatZeroCouponSwapKnownAmountDefault extends IsFixedFloatZeroCouponSwapKnownAmount {
		@Override
		protected Boolean doEvaluate(Product product) {
			Boolean result = null;
			return assignOutput(result, product);
		}
		
		protected Boolean assignOutput(Boolean result, Product product) {
			result = areEqual(MapperS.of(isFixedFloatZeroCouponSwap.evaluate(product)), MapperS.of(true), CardinalityOperator.All).and(exists(MapperS.of(interestRateLeg1ZeroCouponSwapKnownAmount.evaluate(product)))).get();
			
			return result;
		}
	}
}
