package drr.regulation.common.functions;

import cdm.base.staticdata.identifier.IdentifiedList;
import cdm.event.common.BusinessEvent;
import cdm.event.common.ExecutionDetails;
import cdm.event.common.Trade;
import cdm.event.common.TradeState;
import cdm.event.workflow.WorkflowStep;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.ReportableEvent;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(IsPackageIndicator.IsPackageIndicatorDefault.class)
public abstract class IsPackageIndicator implements RosettaFunction {

	/**
	* @param reportableEvent 
	* @return packageIndicator 
	*/
	public Boolean evaluate(ReportableEvent reportableEvent) {
		Boolean packageIndicator = doEvaluate(reportableEvent);
		
		return packageIndicator;
	}

	protected abstract Boolean doEvaluate(ReportableEvent reportableEvent);

	public static class IsPackageIndicatorDefault extends IsPackageIndicator {
		@Override
		protected Boolean doEvaluate(ReportableEvent reportableEvent) {
			Boolean packageIndicator = null;
			return assignOutput(packageIndicator, reportableEvent);
		}
		
		protected Boolean assignOutput(Boolean packageIndicator, ReportableEvent reportableEvent) {
			packageIndicator = exists(MapperS.of(reportableEvent).<WorkflowStep>map("getOriginatingWorkflowStep", _reportableEvent -> _reportableEvent.getOriginatingWorkflowStep()).<BusinessEvent>map("getBusinessEvent", workflowStep -> workflowStep.getBusinessEvent()).<IdentifiedList>map("getPackageInformation", businessEvent -> businessEvent.getPackageInformation())).or(exists(MapperS.of(reportableEvent).<WorkflowStep>map("getOriginatingWorkflowStep", _reportableEvent -> _reportableEvent.getOriginatingWorkflowStep()).<BusinessEvent>map("getBusinessEvent", workflowStep -> workflowStep.getBusinessEvent()).<TradeState>mapC("getAfter", businessEvent -> businessEvent.getAfter()).<Trade>map("getTrade", tradeState -> tradeState.getTrade()).<ExecutionDetails>map("getExecutionDetails", trade -> trade.getExecutionDetails()).<IdentifiedList>map("getPackageReference", executionDetails -> executionDetails.getPackageReference()))).get();
			
			return packageIndicator;
		}
	}
}
