package drr.regulation.common.functions;

import cdm.product.qualification.functions.Qualify_Commodity_Swap_Basis;
import cdm.product.template.EconomicTerms;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.ReportableEvent;
import javax.inject.Inject;


@ImplementedBy(IsReturnorPayoutTriggerCFD.IsReturnorPayoutTriggerCFDDefault.class)
public abstract class IsReturnorPayoutTriggerCFD implements RosettaFunction {
	
	// RosettaFunction dependencies
	//
	@Inject protected EconomicTermsForProduct economicTermsForProduct;
	@Inject protected IsCommoditySwap isCommoditySwap;
	@Inject protected IsEquitySwapProduct isEquitySwapProduct;
	@Inject protected ProductForEvent productForEvent;
	@Inject protected Qualify_Commodity_Swap_Basis qualify_Commodity_Swap_Basis;

	/**
	* @param reportableEvent 
	* @return result 
	*/
	public Boolean evaluate(ReportableEvent reportableEvent) {
		Boolean result = doEvaluate(reportableEvent);
		
		return result;
	}

	protected abstract Boolean doEvaluate(ReportableEvent reportableEvent);

	protected abstract MapperS<? extends Product> product(ReportableEvent reportableEvent);

	protected abstract MapperS<? extends EconomicTerms> economicTerms(ReportableEvent reportableEvent);

	public static class IsReturnorPayoutTriggerCFDDefault extends IsReturnorPayoutTriggerCFD {
		@Override
		protected Boolean doEvaluate(ReportableEvent reportableEvent) {
			Boolean result = null;
			return assignOutput(result, reportableEvent);
		}
		
		protected Boolean assignOutput(Boolean result, ReportableEvent reportableEvent) {
			result = ComparisonResult.of(MapperS.of(qualify_Commodity_Swap_Basis.evaluate(economicTerms(reportableEvent).get()))).or(ComparisonResult.of(MapperS.of(isCommoditySwap.evaluate(product(reportableEvent).get())))).or(ComparisonResult.of(MapperS.of(isEquitySwapProduct.evaluate(product(reportableEvent).get())))).get();
			
			return result;
		}
		
		@Override
		protected MapperS<? extends Product> product(ReportableEvent reportableEvent) {
			return MapperS.of(productForEvent.evaluate(reportableEvent));
		}
		
		@Override
		protected MapperS<? extends EconomicTerms> economicTerms(ReportableEvent reportableEvent) {
			return MapperS.of(economicTermsForProduct.evaluate(product(reportableEvent).get()));
		}
	}
}
