package drr.regulation.common.meta;

import com.rosetta.model.lib.annotations.RosettaMeta;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.qualify.QualifyFunctionFactory;
import com.rosetta.model.lib.qualify.QualifyResult;
import com.rosetta.model.lib.validation.Validator;
import com.rosetta.model.lib.validation.ValidatorFactory;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import drr.regulation.common.ReportingRegime;
import drr.regulation.common.validation.ReportingRegimeTypeFormatValidator;
import drr.regulation.common.validation.ReportingRegimeValidator;
import drr.regulation.common.validation.datarule.ReportingRegimeASICReportingRegime;
import drr.regulation.common.validation.datarule.ReportingRegimeCFTCReportingRegime;
import drr.regulation.common.validation.datarule.ReportingRegimeCSAReportingRegime;
import drr.regulation.common.validation.datarule.ReportingRegimeESMAReportingRegime;
import drr.regulation.common.validation.datarule.ReportingRegimeHKMAReportingRegime;
import drr.regulation.common.validation.datarule.ReportingRegimeSECReportingRegime;
import drr.regulation.common.validation.datarule.ReportingRegimeSupervisorInformation;
import drr.regulation.common.validation.datarule.ReportingRegimeTradingCapacity;
import drr.regulation.common.validation.exists.ReportingRegimeOnlyExistsValidator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;


/**
 * @version 6.17.7
 */
@RosettaMeta(model=ReportingRegime.class)
public class ReportingRegimeMeta implements RosettaMetaData<ReportingRegime> {

	@Override
	public List<Validator<? super ReportingRegime>> dataRules(ValidatorFactory factory) {
		return Arrays.asList(
			factory.<ReportingRegime>create(ReportingRegimeSupervisorInformation.class),
			factory.<ReportingRegime>create(ReportingRegimeCFTCReportingRegime.class),
			factory.<ReportingRegime>create(ReportingRegimeCSAReportingRegime.class),
			factory.<ReportingRegime>create(ReportingRegimeSECReportingRegime.class),
			factory.<ReportingRegime>create(ReportingRegimeESMAReportingRegime.class),
			factory.<ReportingRegime>create(ReportingRegimeASICReportingRegime.class),
			factory.<ReportingRegime>create(ReportingRegimeHKMAReportingRegime.class),
			factory.<ReportingRegime>create(ReportingRegimeTradingCapacity.class)
		);
	}
	
	@Override
	public List<Function<? super ReportingRegime, QualifyResult>> getQualifyFunctions(QualifyFunctionFactory factory) {
		return Collections.emptyList();
	}
	
	@Override
	public Validator<? super ReportingRegime> validator(ValidatorFactory factory) {
		return factory.<ReportingRegime>create(ReportingRegimeValidator.class);
	}

	@Override
	public Validator<? super ReportingRegime> typeFormatValidator(ValidatorFactory factory) {
		return factory.<ReportingRegime>create(ReportingRegimeTypeFormatValidator.class);
	}

	@Deprecated
	@Override
	public Validator<? super ReportingRegime> validator() {
		return new ReportingRegimeValidator();
	}

	@Deprecated
	@Override
	public Validator<? super ReportingRegime> typeFormatValidator() {
		return new ReportingRegimeTypeFormatValidator();
	}
	
	@Override
	public ValidatorWithArg<? super ReportingRegime, Set<String>> onlyExistsValidator() {
		return new ReportingRegimeOnlyExistsValidator();
	}
}
