package drr.regulation.common.trade.index.functions;

import cdm.base.staticdata.asset.common.DebtEconomics;
import cdm.base.staticdata.asset.common.DebtSeniorityEnum;
import cdm.base.staticdata.asset.common.DebtType;
import cdm.base.staticdata.asset.common.Security;
import cdm.product.asset.BasketReferenceInformation;
import cdm.product.asset.CreditDefaultPayout;
import cdm.product.asset.CreditIndexReferenceInformation;
import cdm.product.asset.CreditSeniorityEnum;
import cdm.product.asset.GeneralTerms;
import cdm.product.asset.ReferenceInformation;
import cdm.product.asset.ReferenceObligation;
import cdm.product.asset.ReferencePair;
import cdm.product.asset.ReferencePool;
import cdm.product.asset.ReferencePoolItem;
import cdm.product.template.Payout;
import cdm.product.template.PerformancePayout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.functions.EconomicTermsForProduct;
import drr.regulation.common.functions.IsCreditDefaultSwap;
import drr.regulation.common.functions.IsCreditDefaultSwapBasket;
import drr.regulation.common.functions.IsCreditSwaption;
import drr.regulation.common.functions.IsTotalReturnSwapDebtUnderlier;
import drr.regulation.common.functions.ProductForEvent;
import drr.regulation.common.functions.UnderlierForProduct;
import drr.standards.iso.SeniorityEnum;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(GetSeniority.GetSeniorityDefault.class)
public abstract class GetSeniority implements RosettaFunction {
	
	// RosettaFunction dependencies
	//
	@Inject protected EconomicTermsForProduct economicTermsForProduct;
	@Inject protected IsCreditDefaultSwap isCreditDefaultSwap;
	@Inject protected IsCreditDefaultSwapBasket isCreditDefaultSwapBasket;
	@Inject protected IsCreditSwaption isCreditSwaption;
	@Inject protected IsTotalReturnSwapDebtUnderlier isTotalReturnSwapDebtUnderlier;
	@Inject protected ProductForEvent productForEvent;
	@Inject protected UnderlierForProduct underlierForProduct;

	/**
	* @param reportableEvent 
	* @return result 
	*/
	public SeniorityEnum evaluate(ReportableEvent reportableEvent) {
		SeniorityEnum result = doEvaluate(reportableEvent);
		
		return result;
	}

	protected abstract SeniorityEnum doEvaluate(ReportableEvent reportableEvent);

	protected abstract MapperS<? extends Product> product(ReportableEvent reportableEvent);

	protected abstract MapperS<? extends CreditIndexReferenceInformation> indexReferenceInformation(ReportableEvent reportableEvent);

	protected abstract MapperS<? extends ReferenceInformation> referenceInformation(ReportableEvent reportableEvent);

	protected abstract MapperS<? extends BasketReferenceInformation> basketReferenceInformation(ReportableEvent reportableEvent);

	protected abstract MapperS<CreditSeniorityEnum> creditSeniority(ReportableEvent reportableEvent);

	protected abstract MapperC<DebtSeniorityEnum> debtSeniority(ReportableEvent reportableEvent);

	protected abstract MapperC<DebtSeniorityEnum> basketSeniority(ReportableEvent reportableEvent);

	public static class GetSeniorityDefault extends GetSeniority {
		@Override
		protected SeniorityEnum doEvaluate(ReportableEvent reportableEvent) {
			SeniorityEnum result = null;
			return assignOutput(result, reportableEvent);
		}
		
		protected SeniorityEnum assignOutput(SeniorityEnum result, ReportableEvent reportableEvent) {
			if (areEqual(creditSeniority(reportableEvent), MapperS.of(CreditSeniorityEnum.SENIOR_UN_SEC), CardinalityOperator.All).or(areEqual(creditSeniority(reportableEvent), MapperS.of(CreditSeniorityEnum.SENIOR_SEC), CardinalityOperator.All)).or(areEqual(creditSeniority(reportableEvent), MapperS.of(CreditSeniorityEnum.SENIOR_LOSS_ABSORBING_CAPACITY), CardinalityOperator.All)).or(areEqual(debtSeniority(reportableEvent), MapperS.of(DebtSeniorityEnum.SENIOR), CardinalityOperator.Any)).or(areEqual(basketSeniority(reportableEvent), MapperS.of(DebtSeniorityEnum.SENIOR), CardinalityOperator.All)).getOrDefault(false)) {
				result = SeniorityEnum.SNDB;
			} else if (areEqual(creditSeniority(reportableEvent), MapperS.of(CreditSeniorityEnum.SUB_TIER_3), CardinalityOperator.All).or(areEqual(creditSeniority(reportableEvent), MapperS.of(CreditSeniorityEnum.SUB_UPPER_TIER_2), CardinalityOperator.All)).or(areEqual(creditSeniority(reportableEvent), MapperS.of(CreditSeniorityEnum.SUB_LOWER_TIER_2), CardinalityOperator.All)).or(areEqual(creditSeniority(reportableEvent), MapperS.of(CreditSeniorityEnum.SUB_TIER_1), CardinalityOperator.All)).or(areEqual(debtSeniority(reportableEvent), MapperS.of(DebtSeniorityEnum.SUBORDINATED), CardinalityOperator.Any)).or(areEqual(basketSeniority(reportableEvent), MapperS.of(DebtSeniorityEnum.SUBORDINATED), CardinalityOperator.All)).getOrDefault(false)) {
				result = SeniorityEnum.SBOD;
			} else if (areEqual(creditSeniority(reportableEvent), MapperS.of(CreditSeniorityEnum.OTHER), CardinalityOperator.All).or(areEqual(debtSeniority(reportableEvent), MapperS.of(DebtSeniorityEnum.SECURED), CardinalityOperator.Any)).or(exists(basketSeniority(reportableEvent))).getOrDefault(false)) {
				result = SeniorityEnum.OTHR;
			} else {
				result = null;
			}
			
			return result;
		}
		
		@Override
		protected MapperS<? extends Product> product(ReportableEvent reportableEvent) {
			return MapperS.of(productForEvent.evaluate(reportableEvent));
		}
		
		@Override
		protected MapperS<? extends CreditIndexReferenceInformation> indexReferenceInformation(ReportableEvent reportableEvent) {
			final Boolean boolean0 = isCreditSwaption.evaluate(product(reportableEvent).get());
			if ((boolean0 == null ? false : boolean0)) {
				return MapperS.of(economicTermsForProduct.evaluate(underlierForProduct.evaluate(product(reportableEvent).get()))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CreditDefaultPayout>map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).<GeneralTerms>map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).<CreditIndexReferenceInformation>map("getIndexReferenceInformation", generalTerms -> generalTerms.getIndexReferenceInformation());
			}
			final Boolean boolean1 = isCreditDefaultSwap.evaluate(product(reportableEvent).get());
			if ((boolean1 == null ? false : boolean1)) {
				return MapperS.of(economicTermsForProduct.evaluate(product(reportableEvent).get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CreditDefaultPayout>map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).<GeneralTerms>map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).<CreditIndexReferenceInformation>map("getIndexReferenceInformation", generalTerms -> generalTerms.getIndexReferenceInformation());
			}
			return MapperS.<CreditIndexReferenceInformation>ofNull();
		}
		
		@Override
		protected MapperS<? extends ReferenceInformation> referenceInformation(ReportableEvent reportableEvent) {
			final Boolean boolean0 = isCreditSwaption.evaluate(product(reportableEvent).get());
			if ((boolean0 == null ? false : boolean0)) {
				return MapperS.of(economicTermsForProduct.evaluate(underlierForProduct.evaluate(product(reportableEvent).get()))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CreditDefaultPayout>map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).<GeneralTerms>map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).<ReferenceInformation>map("getReferenceInformation", generalTerms -> generalTerms.getReferenceInformation());
			}
			final Boolean boolean1 = isCreditDefaultSwap.evaluate(product(reportableEvent).get());
			if ((boolean1 == null ? false : boolean1)) {
				return MapperS.of(economicTermsForProduct.evaluate(product(reportableEvent).get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CreditDefaultPayout>map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).<GeneralTerms>map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).<ReferenceInformation>map("getReferenceInformation", generalTerms -> generalTerms.getReferenceInformation());
			}
			return MapperS.<ReferenceInformation>ofNull();
		}
		
		@Override
		protected MapperS<? extends BasketReferenceInformation> basketReferenceInformation(ReportableEvent reportableEvent) {
			final Boolean boolean0 = isCreditSwaption.evaluate(product(reportableEvent).get());
			if ((boolean0 == null ? false : boolean0)) {
				return MapperS.of(economicTermsForProduct.evaluate(underlierForProduct.evaluate(product(reportableEvent).get()))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CreditDefaultPayout>map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).<GeneralTerms>map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).<BasketReferenceInformation>map("getBasketReferenceInformation", generalTerms -> generalTerms.getBasketReferenceInformation());
			}
			final Boolean boolean1 = isCreditDefaultSwapBasket.evaluate(product(reportableEvent).get());
			if ((boolean1 == null ? false : boolean1)) {
				return MapperS.of(economicTermsForProduct.evaluate(product(reportableEvent).get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CreditDefaultPayout>map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).<GeneralTerms>map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).<BasketReferenceInformation>map("getBasketReferenceInformation", generalTerms -> generalTerms.getBasketReferenceInformation());
			}
			return MapperS.<BasketReferenceInformation>ofNull();
		}
		
		@Override
		protected MapperS<CreditSeniorityEnum> creditSeniority(ReportableEvent reportableEvent) {
			return indexReferenceInformation(reportableEvent).<CreditSeniorityEnum>map("getSeniority", creditIndexReferenceInformation -> creditIndexReferenceInformation.getSeniority());
		}
		
		@Override
		protected MapperC<DebtSeniorityEnum> debtSeniority(ReportableEvent reportableEvent) {
			if (exists(referenceInformation(reportableEvent)).getOrDefault(false)) {
				return referenceInformation(reportableEvent).<ReferenceObligation>mapC("getReferenceObligation", _referenceInformation -> _referenceInformation.getReferenceObligation()).<Security>map("getSecurity", referenceObligation -> referenceObligation.getSecurity()).<DebtType>map("getDebtType", security -> security.getDebtType()).<DebtEconomics>mapC("getDebtEconomics", debtType -> debtType.getDebtEconomics()).<DebtSeniorityEnum>map("getDebtSeniority", debtEconomics -> debtEconomics.getDebtSeniority());
			}
			final Boolean _boolean = isTotalReturnSwapDebtUnderlier.evaluate(product(reportableEvent).get());
			if ((_boolean == null ? false : _boolean)) {
				return MapperS.of(MapperS.of(economicTermsForProduct.evaluate(product(reportableEvent).get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<PerformancePayout>mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).get()).<Product>map("getUnderlier", performancePayout -> performancePayout.getUnderlier()).<Security>map("getSecurity", _product -> _product.getSecurity()).<DebtType>map("getDebtType", security -> security.getDebtType()).<DebtEconomics>mapC("getDebtEconomics", debtType -> debtType.getDebtEconomics()).<DebtSeniorityEnum>map("getDebtSeniority", debtEconomics -> debtEconomics.getDebtSeniority());
			}
			return MapperC.<DebtSeniorityEnum>ofNull();
		}
		
		@Override
		protected MapperC<DebtSeniorityEnum> basketSeniority(ReportableEvent reportableEvent) {
			if (exists(basketReferenceInformation(reportableEvent)).getOrDefault(false)) {
				return basketReferenceInformation(reportableEvent).<ReferencePool>map("getReferencePool", _basketReferenceInformation -> _basketReferenceInformation.getReferencePool()).<ReferencePoolItem>mapC("getReferencePoolItem", referencePool -> referencePool.getReferencePoolItem()).<ReferencePair>map("getReferencePair", referencePoolItem -> referencePoolItem.getReferencePair()).<ReferenceObligation>map("getReferenceObligation", referencePair -> referencePair.getReferenceObligation()).<Security>map("getSecurity", referenceObligation -> referenceObligation.getSecurity()).<DebtType>map("getDebtType", security -> security.getDebtType()).<DebtEconomics>mapC("getDebtEconomics", debtType -> debtType.getDebtEconomics()).<DebtSeniorityEnum>map("getDebtSeniority", debtEconomics -> debtEconomics.getDebtSeniority());
			}
			return MapperC.<DebtSeniorityEnum>ofNull();
		}
	}
}
