package drr.regulation.common.trade.payment.reports;

import cdm.product.common.schedule.ResetFrequency;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import javax.inject.Inject;


@ImplementedBy(FloatingRateResetFrequencyPeriodMultiplierLeg2Rule.FloatingRateResetFrequencyPeriodMultiplierLeg2RuleDefault.class)
public abstract class FloatingRateResetFrequencyPeriodMultiplierLeg2Rule implements ReportFunction<TransactionReportInstruction, Integer> {
	
	// RosettaFunction dependencies
	//
	@Inject protected FloatingRateResetFrequencyLeg2Rule floatingRateResetFrequencyLeg2Rule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public Integer evaluate(TransactionReportInstruction input) {
		Integer output = doEvaluate(input);
		
		return output;
	}

	protected abstract Integer doEvaluate(TransactionReportInstruction input);

	public static class FloatingRateResetFrequencyPeriodMultiplierLeg2RuleDefault extends FloatingRateResetFrequencyPeriodMultiplierLeg2Rule {
		@Override
		protected Integer doEvaluate(TransactionReportInstruction input) {
			Integer output = null;
			return assignOutput(output, input);
		}
		
		protected Integer assignOutput(Integer output, TransactionReportInstruction input) {
			final MapperS<ResetFrequency> thenArg = MapperS.of(floatingRateResetFrequencyLeg2Rule.evaluate(input));
			output = thenArg
				.mapSingleToItem(item -> item.<Integer>map("getPeriodMultiplier", resetFrequency -> resetFrequency.getPeriodMultiplier())).get();
			
			return output;
		}
	}
}
