package drr.regulation.common.trade.quantity.functions;

import cdm.base.datetime.Frequency;
import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.base.math.metafields.FieldWithMetaNonNegativeQuantitySchedule;
import cdm.event.common.Trade;
import cdm.observable.asset.metafields.FieldWithMetaPriceSchedule;
import cdm.product.asset.CommodityPayout;
import cdm.product.common.schedule.CalculationPeriodDates;
import cdm.product.common.settlement.PriceQuantity;
import cdm.product.template.ContractualProduct;
import cdm.product.template.EconomicTerms;
import cdm.product.template.ForwardPayout;
import cdm.product.template.Payout;
import cdm.product.template.TradableProduct;
import cdm.product.template.TradeLot;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.functions.CommodityForwardObservablePriceQuantity;
import drr.regulation.common.functions.CommodityLeg2;
import drr.regulation.common.functions.CommodityObservablePriceQuantity;
import drr.regulation.common.functions.FrequencyPeriod;
import drr.regulation.common.functions.IsCommodityFixedPriceForward;
import drr.regulation.common.functions.IsCommodityFloatingPriceForward;
import drr.regulation.common.functions.IsCommoditySwap;
import drr.regulation.common.functions.ProductForTrade;
import drr.regulation.common.functions.QuantityFrequencyOrCalculationPeriod;
import drr.regulation.common.functions.TradeForEvent;
import drr.regulation.common.trade.quantity.QuantityFrequency;
import java.util.Optional;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(QuantityFrequencyLeg2.QuantityFrequencyLeg2Default.class)
public abstract class QuantityFrequencyLeg2 implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected CommodityForwardObservablePriceQuantity commodityForwardObservablePriceQuantity;
	@Inject protected CommodityLeg2 commodityLeg2;
	@Inject protected CommodityObservablePriceQuantity commodityObservablePriceQuantity;
	@Inject protected FrequencyPeriod frequencyPeriod;
	@Inject protected IsCommodityFixedPriceForward isCommodityFixedPriceForward;
	@Inject protected IsCommodityFloatingPriceForward isCommodityFloatingPriceForward;
	@Inject protected IsCommoditySwap isCommoditySwap;
	@Inject protected ProductForTrade productForTrade;
	@Inject protected QuantityFrequencyOrCalculationPeriod quantityFrequencyOrCalculationPeriod;
	@Inject protected TradeForEvent tradeForEvent;

	/**
	* @param reportableEvent 
	* @return quantityFrequency 
	*/
	public QuantityFrequency evaluate(ReportableEvent reportableEvent) {
		QuantityFrequency.QuantityFrequencyBuilder quantityFrequencyBuilder = doEvaluate(reportableEvent);
		
		final QuantityFrequency quantityFrequency;
		if (quantityFrequencyBuilder == null) {
			quantityFrequency = null;
		} else {
			quantityFrequency = quantityFrequencyBuilder.build();
			objectValidator.validate(QuantityFrequency.class, quantityFrequency);
		}
		
		return quantityFrequency;
	}

	protected abstract QuantityFrequency.QuantityFrequencyBuilder doEvaluate(ReportableEvent reportableEvent);

	protected abstract MapperS<? extends PriceQuantity> quantity(ReportableEvent reportableEvent);

	protected abstract MapperS<? extends Frequency> frequency(ReportableEvent reportableEvent);

	public static class QuantityFrequencyLeg2Default extends QuantityFrequencyLeg2 {
		@Override
		protected QuantityFrequency.QuantityFrequencyBuilder doEvaluate(ReportableEvent reportableEvent) {
			QuantityFrequency.QuantityFrequencyBuilder quantityFrequency = QuantityFrequency.builder();
			return assignOutput(quantityFrequency, reportableEvent);
		}
		
		protected QuantityFrequency.QuantityFrequencyBuilder assignOutput(QuantityFrequency.QuantityFrequencyBuilder quantityFrequency, ReportableEvent reportableEvent) {
			quantityFrequency = toBuilder(QuantityFrequency.builder()
				.setPeriod(frequencyPeriod.evaluate(quantity(reportableEvent).get(), frequency(reportableEvent).get()))
				.setPeriodMultiplier(frequency(reportableEvent).<Integer>map("getPeriodMultiplier", _frequency -> _frequency.getPeriodMultiplier()).get())
				.build());
			
			return Optional.ofNullable(quantityFrequency)
				.map(o -> o.prune())
				.orElse(null);
		}
		
		@Override
		protected MapperS<? extends PriceQuantity> quantity(ReportableEvent reportableEvent) {
			final MapperS<Trade> thenArg = MapperS.of(tradeForEvent.evaluate(reportableEvent));
			return thenArg
				.mapSingleToItem(item -> {
					final Boolean boolean0 = isCommoditySwap.evaluate(productForTrade.evaluate(item.get()));
					if ((boolean0 == null ? false : boolean0)) {
						return MapperS.of(commodityObservablePriceQuantity.evaluate(item.<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<TradeLot>mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).get(), commodityLeg2.evaluate(productForTrade.evaluate(item.get()))));
					}
					final Boolean boolean1 = isCommodityFixedPriceForward.evaluate(productForTrade.evaluate(item.get()));
					if ((boolean1 == null ? false : boolean1)) {
						final MapperC<PriceQuantity> _thenArg = item.<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<TradeLot>mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).<PriceQuantity>mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity())
							.filterItemNullSafe(pq -> notExists(pq.<FieldWithMetaPriceSchedule>mapC("getPrice", priceQuantity -> priceQuantity.getPrice())).get());
						return MapperS.of(_thenArg.get());
					}
					final Boolean boolean2 = isCommodityFloatingPriceForward.evaluate(productForTrade.evaluate(item.get()));
					if ((boolean2 == null ? false : boolean2)) {
						return MapperS.of(commodityForwardObservablePriceQuantity.evaluate(item.<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<TradeLot>mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).get(), MapperS.of(productForTrade.evaluate(item.get())).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<ForwardPayout>mapC("getForwardPayout", payout -> payout.getForwardPayout()).get()));
					}
					return MapperS.<PriceQuantity>ofNull();
				});
		}
		
		@Override
		protected MapperS<? extends Frequency> frequency(ReportableEvent reportableEvent) {
			final MapperS<Trade> thenArg = MapperS.of(tradeForEvent.evaluate(reportableEvent));
			return thenArg
				.mapSingleToItem(item -> {
					final Boolean boolean0 = isCommoditySwap.evaluate(productForTrade.evaluate(item.get()));
					if ((boolean0 == null ? false : boolean0)) {
						return MapperS.of(quantityFrequencyOrCalculationPeriod.evaluate(MapperS.of(commodityLeg2.evaluate(productForTrade.evaluate(item.get()))).<CalculationPeriodDates>map("getCalculationPeriodDates", commodityPayout -> commodityPayout.getCalculationPeriodDates()).get(), commodityObservablePriceQuantity.evaluate(item.<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<TradeLot>mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).get(), commodityLeg2.evaluate(productForTrade.evaluate(item.get())))));
					}
					final Boolean boolean1 = isCommodityFixedPriceForward.evaluate(productForTrade.evaluate(item.get()));
					if ((boolean1 == null ? false : boolean1)) {
						return MapperS.of(item.<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<TradeLot>mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).<PriceQuantity>mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity())
							.filterItemNullSafe(pq -> notExists(pq.<FieldWithMetaPriceSchedule>mapC("getPrice", priceQuantity -> priceQuantity.getPrice())).get()).<FieldWithMetaNonNegativeQuantitySchedule>mapC("getQuantity", priceQuantity -> priceQuantity.getQuantity())
							.filterItemNullSafe(q -> exists(q.<NonNegativeQuantitySchedule>map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule == null ? null : fieldWithMetaNonNegativeQuantitySchedule.getValue()).<Frequency>map("getFrequency", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getFrequency())).get()).<NonNegativeQuantitySchedule>map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule.getValue()).<Frequency>map("getFrequency", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getFrequency()).get());
					}
					final Boolean boolean2 = isCommodityFloatingPriceForward.evaluate(productForTrade.evaluate(item.get()));
					if ((boolean2 == null ? false : boolean2)) {
						return MapperS.of(quantityFrequencyOrCalculationPeriod.evaluate(MapperS.of(productForTrade.evaluate(item.get())).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CommodityPayout>mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).<CalculationPeriodDates>map("getCalculationPeriodDates", commodityPayout -> commodityPayout.getCalculationPeriodDates()).get(), commodityForwardObservablePriceQuantity.evaluate(item.<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<TradeLot>mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).get(), MapperS.of(productForTrade.evaluate(item.get())).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<ForwardPayout>mapC("getForwardPayout", payout -> payout.getForwardPayout()).get())));
					}
					return MapperS.<Frequency>ofNull();
				});
		}
	}
}
