package drr.regulation.common.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.CommodityTimeUnitEnum;
import drr.regulation.common.ESMATransactionInformation;
import drr.regulation.common.TradableOnTradingVenueEnum;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.toList;

public class ESMATransactionInformationValidator implements Validator<ESMATransactionInformation> {

	private List<ComparisonResult> getComparisonResults(ESMATransactionInformation o) {
		return Lists.<ComparisonResult>newArrayList(
				checkCardinality("tradableOnTradingVenue", (TradableOnTradingVenueEnum) o.getTradableOnTradingVenue() != null ? 1 : 0, 0, 1), 
				checkCardinality("underlierTradedOnTradingVenue", (Boolean) o.getUnderlierTradedOnTradingVenue() != null ? 1 : 0, 0, 1), 
				checkCardinality("underlierAssetTradingPlatformIdentifier", (String) o.getUnderlierAssetTradingPlatformIdentifier() != null ? 1 : 0, 0, 1), 
				checkCardinality("duration", (CommodityTimeUnitEnum) o.getDuration() != null ? 1 : 0, 0, 1)
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, ESMATransactionInformation o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("ESMATransactionInformation", ValidationResult.ValidationType.CARDINALITY, "ESMATransactionInformation", path, "", res.getError());
				}
				return success("ESMATransactionInformation", ValidationResult.ValidationType.CARDINALITY, "ESMATransactionInformation", path, "");
			})
			.collect(toList());
	}

}
