package drr.regulation.common.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.ESMAPartyInformation;
import drr.regulation.common.FCAPartyInformation;
import drr.regulation.common.ReportingRegime;
import drr.regulation.common.SupervisoryBodyEnum;
import drr.regulation.common.metafields.FieldWithMetaSupervisoryBodyEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 6.17.7
 */
@RosettaDataRule("ReportingRegimeESMAReportingRegime")
@ImplementedBy(ReportingRegimeESMAReportingRegime.Default.class)
public interface ReportingRegimeESMAReportingRegime extends Validator<ReportingRegime> {
	
	String NAME = "ReportingRegimeESMAReportingRegime";
	String DEFINITION = "if supervisoryBody = SupervisoryBodyEnum -> ESMA then esmaPartyInformation exists else if supervisoryBody = SupervisoryBodyEnum -> FCA then fcaPartyInformation exists else esmaPartyInformation is absent";
	
	class Default implements ReportingRegimeESMAReportingRegime {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, ReportingRegime reportingRegime) {
			ComparisonResult result = executeDataRule(reportingRegime);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "ReportingRegime", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "ReportingRegime", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(ReportingRegime reportingRegime) {
			try {
				if (areEqual(MapperS.of(reportingRegime).<FieldWithMetaSupervisoryBodyEnum>map("getSupervisoryBody", _reportingRegime -> _reportingRegime.getSupervisoryBody()).<SupervisoryBodyEnum>map("Type coercion", fieldWithMetaSupervisoryBodyEnum0 -> fieldWithMetaSupervisoryBodyEnum0 == null ? null : fieldWithMetaSupervisoryBodyEnum0.getValue()), MapperS.of(SupervisoryBodyEnum.ESMA), CardinalityOperator.All).getOrDefault(false)) {
					return exists(MapperS.of(reportingRegime).<ESMAPartyInformation>map("getEsmaPartyInformation", _reportingRegime -> _reportingRegime.getEsmaPartyInformation()));
				}
				if (areEqual(MapperS.of(reportingRegime).<FieldWithMetaSupervisoryBodyEnum>map("getSupervisoryBody", _reportingRegime -> _reportingRegime.getSupervisoryBody()).<SupervisoryBodyEnum>map("Type coercion", fieldWithMetaSupervisoryBodyEnum1 -> fieldWithMetaSupervisoryBodyEnum1 == null ? null : fieldWithMetaSupervisoryBodyEnum1.getValue()), MapperS.of(SupervisoryBodyEnum.FCA), CardinalityOperator.All).getOrDefault(false)) {
					return exists(MapperS.of(reportingRegime).<FCAPartyInformation>map("getFcaPartyInformation", _reportingRegime -> _reportingRegime.getFcaPartyInformation()));
				}
				return notExists(MapperS.of(reportingRegime).<ESMAPartyInformation>map("getEsmaPartyInformation", _reportingRegime -> _reportingRegime.getEsmaPartyInformation()));
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements ReportingRegimeESMAReportingRegime {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, ReportingRegime reportingRegime) {
			return Collections.emptyList();
		}
	}
}
