package drr.regulation.csa.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaReport;
import com.rosetta.model.lib.annotations.RuneLabelProvider;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.enrichment.common.reports.EnrichmentDataRule;
import drr.enrichment.common.reports.UpiPostEnrichmentDataRule;
import drr.enrichment.common.reports.UpiPreEnrichmentDataRule;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.dtcc.reports.DTCC_Comment1Rule;
import drr.regulation.common.dtcc.reports.DTCC_CorporateActionNewTradeParty1LEIRule;
import drr.regulation.common.dtcc.reports.DTCC_DeliveryLocationRule;
import drr.regulation.common.dtcc.reports.DTCC_MaturityDateOfTheUnderlyingRule;
import drr.regulation.common.dtcc.reports.DTCC_OptionStyleRule;
import drr.regulation.common.dtcc.reports.DTCC_OptionTypeRule;
import drr.regulation.common.dtcc.reports.DTCC_PrimaryAssetClassRule;
import drr.regulation.common.dtcc.reports.DTCC_ProductIDRule;
import drr.regulation.common.dtcc.reports.DTCC_ResponsibleDataSubmitterIDRule;
import drr.regulation.common.dtcc.reports.DTCC_ResponsibleDataSubmitterIDTypeRule;
import drr.regulation.common.dtcc.reports.DTCC_SettlementTypeRule;
import drr.regulation.common.dtcc.reports.DTCC_SubmittedForPartyRule;
import drr.regulation.common.dtcc.reports.DTCC_SubmittingPartyIDTypeRule;
import drr.regulation.common.dtcc.reports.DTCC_TradeLegTypesRule;
import drr.regulation.common.dtcc.reports.DTCC_TradeParty1ExecutionAgentIDRule;
import drr.regulation.common.dtcc.reports.DTCC_TradeParty1ExecutionAgentIDTypeRule;
import drr.regulation.common.dtcc.reports.DTCC_TradeParty1ReportingDestinationRule;
import drr.regulation.common.dtcc.reports.DTCC_TradeParty1TransactionIDRule;
import drr.regulation.common.dtcc.reports.DTCC_TradeParty2ExecutionAgentIDRule;
import drr.regulation.common.dtcc.reports.DTCC_TradeParty2ExecutionAgentIDTypeRule;
import drr.regulation.common.trade.contract.reports.UnderlyingAssetTypeRule;
import drr.regulation.common.trade.price.reports.SingleOrUpperAndLowerBarrierRule;
import drr.regulation.common.trade.quantity.reports.NotionalScheduleRule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_MessageIDRule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_MessageTypePPDRule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_TradeParty1IDTypeRule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_USIIDPrefixRule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_USIIDRule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_UnderlyingAssetNameRule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_UnderlyingAssetReportRule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_VersionPPDRule;
import drr.regulation.csa.rewrite.trade.CSATransactionReport;
import drr.regulation.csa.rewrite.trade.labels.CSAPPDLabelProvider;
import drr.standards.iosco.cde.version3.party.reports.Counterparty2IdentifierTypeIndicatorRule;
import drr.standards.iosco.cde.version3.price.reports.FirstExerciseDateRule;
import drr.standards.iosco.cde.version3.price.reports.PriceScheduleRule;
import java.util.Optional;
import javax.inject.Inject;


@RosettaReport(namespace="drr.regulation.csa.rewrite.trade", body="CSA", corpusList={"PPD"})
@RuneLabelProvider(labelProvider=CSAPPDLabelProvider.class)
@ImplementedBy(CSAPPDReportFunction.CSAPPDReportFunctionDefault.class)
public abstract class CSAPPDReportFunction implements ReportFunction<TransactionReportInstruction, CSATransactionReport> {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected ActionTypeRule actionTypeRule;
	@Inject protected AmendmentIndicatorRule amendmentIndicatorRule;
	@Inject protected CallAmountRule callAmountRule;
	@Inject protected CallCurrencyRule callCurrencyRule;
	@Inject protected ClearedRule clearedRule;
	@Inject protected ClearingExceptionsAndExemptionsCounterparty1Rule clearingExceptionsAndExemptionsCounterparty1Rule;
	@Inject protected ClearingExceptionsAndExemptionsCounterparty2Rule clearingExceptionsAndExemptionsCounterparty2Rule;
	@Inject protected Counterparty1Rule counterparty1Rule;
	@Inject protected Counterparty2IdentifierSourceRule counterparty2IdentifierSourceRule;
	@Inject protected Counterparty2IdentifierTypeIndicatorRule counterparty2IdentifierTypeIndicatorRule;
	@Inject protected Counterparty2Rule counterparty2Rule;
	@Inject protected CustomBasketIndicatorRule customBasketIndicatorRule;
	@Inject protected DTCC_Comment1Rule dTCC_Comment1Rule;
	@Inject protected DTCC_CorporateActionNewTradeParty1LEIRule dTCC_CorporateActionNewTradeParty1LEIRule;
	@Inject protected DTCC_DeliveryLocationRule dTCC_DeliveryLocationRule;
	@Inject protected DTCC_MaturityDateOfTheUnderlyingRule dTCC_MaturityDateOfTheUnderlyingRule;
	@Inject protected DTCC_MessageIDRule dTCC_MessageIDRule;
	@Inject protected DTCC_MessageTypePPDRule dTCC_MessageTypePPDRule;
	@Inject protected DTCC_OptionStyleRule dTCC_OptionStyleRule;
	@Inject protected DTCC_OptionTypeRule dTCC_OptionTypeRule;
	@Inject protected DTCC_PrimaryAssetClassRule dTCC_PrimaryAssetClassRule;
	@Inject protected DTCC_ProductIDRule dTCC_ProductIDRule;
	@Inject protected DTCC_ResponsibleDataSubmitterIDRule dTCC_ResponsibleDataSubmitterIDRule;
	@Inject protected DTCC_ResponsibleDataSubmitterIDTypeRule dTCC_ResponsibleDataSubmitterIDTypeRule;
	@Inject protected DTCC_SettlementTypeRule dTCC_SettlementTypeRule;
	@Inject protected DTCC_SubmittedForPartyRule dTCC_SubmittedForPartyRule;
	@Inject protected DTCC_SubmittingPartyIDTypeRule dTCC_SubmittingPartyIDTypeRule;
	@Inject protected DTCC_TradeLegTypesRule dTCC_TradeLegTypesRule;
	@Inject protected DTCC_TradeParty1ExecutionAgentIDRule dTCC_TradeParty1ExecutionAgentIDRule;
	@Inject protected DTCC_TradeParty1ExecutionAgentIDTypeRule dTCC_TradeParty1ExecutionAgentIDTypeRule;
	@Inject protected DTCC_TradeParty1IDTypeRule dTCC_TradeParty1IDTypeRule;
	@Inject protected DTCC_TradeParty1ReportingDestinationRule dTCC_TradeParty1ReportingDestinationRule;
	@Inject protected DTCC_TradeParty1TransactionIDRule dTCC_TradeParty1TransactionIDRule;
	@Inject protected DTCC_TradeParty2ExecutionAgentIDRule dTCC_TradeParty2ExecutionAgentIDRule;
	@Inject protected DTCC_TradeParty2ExecutionAgentIDTypeRule dTCC_TradeParty2ExecutionAgentIDTypeRule;
	@Inject protected DTCC_USIIDPrefixRule dTCC_USIIDPrefixRule;
	@Inject protected DTCC_USIIDRule dTCC_USIIDRule;
	@Inject protected DTCC_UnderlyingAssetNameRule dTCC_UnderlyingAssetNameRule;
	@Inject protected DTCC_UnderlyingAssetReportRule dTCC_UnderlyingAssetReportRule;
	@Inject protected DTCC_VersionPPDRule dTCC_VersionPPDRule;
	@Inject protected DeliveryTypeRule deliveryTypeRule;
	@Inject protected EffectiveDateRule effectiveDateRule;
	@Inject protected EmbeddedOptionTypeRule embeddedOptionTypeRule;
	@Inject protected EnrichmentDataRule enrichmentDataRule;
	@Inject protected EventTimestampRule eventTimestampRule;
	@Inject protected EventTypeRule eventTypeRule;
	@Inject protected ExchangeRateBasisRule exchangeRateBasisRule;
	@Inject protected ExchangeRateRule exchangeRateRule;
	@Inject protected ExecutionTimestampRule executionTimestampRule;
	@Inject protected ExecutionVenueTypeRule executionVenueTypeRule;
	@Inject protected ExpirationDateRule expirationDateRule;
	@Inject protected FirstExerciseDateRule firstExerciseDateRule;
	@Inject protected IndexFactorRule indexFactorRule;
	@Inject protected InstrumentTypeRule instrumentTypeRule;
	@Inject protected Leg1ReportPPDRule leg1ReportPPDRule;
	@Inject protected Leg2ReportPPDRule leg2ReportPPDRule;
	@Inject protected NonStandardizedTermIndicatorRule nonStandardizedTermIndicatorRule;
	@Inject protected NotionalScheduleRule notionalScheduleRule;
	@Inject protected OptionPremiumAmountRule optionPremiumAmountRule;
	@Inject protected OptionPremiumCurrencyRule optionPremiumCurrencyRule;
	@Inject protected OtherPaymentRule otherPaymentRule;
	@Inject protected PackageIndicatorRule packageIndicatorRule;
	@Inject protected PackageTransactionPriceCurrencyRule packageTransactionPriceCurrencyRule;
	@Inject protected PackageTransactionPriceNotationRule packageTransactionPriceNotationRule;
	@Inject protected PackageTransactionPriceRule packageTransactionPriceRule;
	@Inject protected PackageTransactionSpreadCurrencyRule packageTransactionSpreadCurrencyRule;
	@Inject protected PackageTransactionSpreadNotationRule packageTransactionSpreadNotationRule;
	@Inject protected PackageTransactionSpreadRule packageTransactionSpreadRule;
	@Inject protected PlatformAnonymousExecutionIndicatorRule platformAnonymousExecutionIndicatorRule;
	@Inject protected PlatformIdentifierRule platformIdentifierRule;
	@Inject protected PriceCurrencyRule priceCurrencyRule;
	@Inject protected PriceNotationRule priceNotationRule;
	@Inject protected PriceRule priceRule;
	@Inject protected PriceScheduleRule priceScheduleRule;
	@Inject protected PriceUnitOfMeasureRule priceUnitOfMeasureRule;
	@Inject protected PutAmountRule putAmountRule;
	@Inject protected PutCurrencyRule putCurrencyRule;
	@Inject protected ReportingTimestampRule reportingTimestampRule;
	@Inject protected ReturnorPayoutTriggerRule returnorPayoutTriggerRule;
	@Inject protected SettlementLocationRule settlementLocationRule;
	@Inject protected SingleOrUpperAndLowerBarrierRule singleOrUpperAndLowerBarrierRule;
	@Inject protected StrikePriceCurrencyCurrencyPairRule strikePriceCurrencyCurrencyPairRule;
	@Inject protected StrikePriceNotationRule strikePriceNotationRule;
	@Inject protected StrikePriceRule strikePriceRule;
	@Inject protected SubmitterIdentifierRule submitterIdentifierRule;
	@Inject protected SubsequentPositionUTIRule subsequentPositionUTIRule;
	@Inject protected UnderlyingAssetTypeRule underlyingAssetTypeRule;
	@Inject protected UniqueProductIdentifierRule uniqueProductIdentifierRule;
	@Inject protected UniqueTransactionIdentifierRule uniqueTransactionIdentifierRule;
	@Inject protected UpiPostEnrichmentDataRule upiPostEnrichmentDataRule;
	@Inject protected UpiPreEnrichmentDataRule upiPreEnrichmentDataRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public CSATransactionReport evaluate(TransactionReportInstruction input) {
		CSATransactionReport.CSATransactionReportBuilder outputBuilder = doEvaluate(input);
		
		final CSATransactionReport output;
		if (outputBuilder == null) {
			output = null;
		} else {
			output = outputBuilder.build();
			objectValidator.validate(CSATransactionReport.class, output);
		}
		
		return output;
	}

	protected abstract CSATransactionReport.CSATransactionReportBuilder doEvaluate(TransactionReportInstruction input);

	public static class CSAPPDReportFunctionDefault extends CSAPPDReportFunction {
		@Override
		protected CSATransactionReport.CSATransactionReportBuilder doEvaluate(TransactionReportInstruction input) {
			CSATransactionReport.CSATransactionReportBuilder output = CSATransactionReport.builder();
			return assignOutput(output, input);
		}
		
		protected CSATransactionReport.CSATransactionReportBuilder assignOutput(CSATransactionReport.CSATransactionReportBuilder output, TransactionReportInstruction input) {
			output
				.setEffectiveDate(effectiveDateRule.evaluate(input));
			
			output
				.setReportingTimestamp(reportingTimestampRule.evaluate(input));
			
			output
				.setExecutionTimestamp(executionTimestampRule.evaluate(input));
			
			output
				.setExpirationDate(expirationDateRule.evaluate(input));
			
			output
				.setCounterparty1(counterparty1Rule.evaluate(input));
			
			output
				.setCounterparty2(counterparty2Rule.evaluate(input));
			
			output
				.setCounterparty2IdentifierType(counterparty2IdentifierTypeIndicatorRule.evaluate(input));
			
			output
				.setCleared(clearedRule.evaluate(input));
			
			output
				.setCallAmount(callAmountRule.evaluate(input));
			
			output
				.setPutAmount(putAmountRule.evaluate(input));
			
			output
				.setCallCurrency(callCurrencyRule.evaluate(input));
			
			output
				.setPutCurrency(putCurrencyRule.evaluate(input));
			
			output
				.setPriceSchedule(priceScheduleRule.evaluate(input));
			
			output
				.setPrice(priceRule.evaluate(input));
			
			output
				.setPriceNotation(priceNotationRule.evaluate(input));
			
			output
				.setPriceCurrency(priceCurrencyRule.evaluate(input));
			
			output
				.setPackageTransactionPrice(packageTransactionPriceRule.evaluate(input));
			
			output
				.setPackageTransactionPriceNotation(packageTransactionPriceNotationRule.evaluate(input));
			
			output
				.setPackageTransactionPriceCurrency(packageTransactionPriceCurrencyRule.evaluate(input));
			
			output
				.setPackageTransactionSpread(packageTransactionSpreadRule.evaluate(input));
			
			output
				.setPackageTransactionSpreadNotation(packageTransactionSpreadNotationRule.evaluate(input));
			
			output
				.setPackageTransactionSpreadCurrency(packageTransactionSpreadCurrencyRule.evaluate(input));
			
			output
				.setStrikePrice(strikePriceRule.evaluate(input));
			
			output
				.setStrikePriceNotation(strikePriceNotationRule.evaluate(input));
			
			output
				.setStrikePriceCurrency(strikePriceCurrencyCurrencyPairRule.evaluate(input));
			
			output
				.setPriceUnitOfMeasure(priceUnitOfMeasureRule.evaluate(input));
			
			output
				.setOptionPremiumAmount(optionPremiumAmountRule.evaluate(input));
			
			output
				.setOptionPremiumCurrency(optionPremiumCurrencyRule.evaluate(input));
			
			output
				.setExchangeRate(exchangeRateRule.evaluate(input));
			
			output
				.setExchangeRateBasis(exchangeRateBasisRule.evaluate(input));
			
			output
				.setFirstExerciseDate(firstExerciseDateRule.evaluate(input));
			
			output
				.setSettlementLocation(settlementLocationRule.evaluate(input));
			
			output
				.setOtherPayment(otherPaymentRule.evaluate(input));
			
			output
				.setLeg1(leg1ReportPPDRule.evaluate(input));
			
			output
				.setLeg2(leg2ReportPPDRule.evaluate(input));
			
			output
				.setActionType(actionTypeRule.evaluate(input));
			
			output
				.setEventType(eventTypeRule.evaluate(input));
			
			output
				.setEventTimestampOverriddenAsZonedDateTime(eventTimestampRule.evaluate(input));
			
			output
				.setReportSubmittingEntityID(submitterIdentifierRule.evaluate(input));
			
			output
				.setUniqueTransactionIdentifier(uniqueTransactionIdentifierRule.evaluate(input));
			
			output
				.setUniqueProductIdentifier(uniqueProductIdentifierRule.evaluate(input));
			
			output
				.setPlatformIdentifier(platformIdentifierRule.evaluate(input));
			
			output
				.setBarrier(singleOrUpperAndLowerBarrierRule.evaluate(input));
			
			output
				.setEmbeddedOptionType(embeddedOptionTypeRule.evaluate(input));
			
			output
				.setIndexFactor(indexFactorRule.evaluate(input));
			
			output
				.setSubsequentPositionUTI(subsequentPositionUTIRule.evaluate(input));
			
			output
				.setNonStandardizedTermIndicator(nonStandardizedTermIndicatorRule.evaluate(input));
			
			output
				.setAmendmentIndicator(amendmentIndicatorRule.evaluate(input));
			
			output
				.setPackageIndicator(packageIndicatorRule.evaluate(input));
			
			output
				.setClearingExceptionsAndExemptionsCounterparty1(clearingExceptionsAndExemptionsCounterparty1Rule.evaluate(input));
			
			output
				.setClearingExceptionsAndExemptionsCounterparty2(clearingExceptionsAndExemptionsCounterparty2Rule.evaluate(input));
			
			output
				.setCounterparty2IdentifierSourceOverriddenAsCounterparty2IdentifierEnum(counterparty2IdentifierSourceRule.evaluate(input));
			
			output
				.setCustomBasketIndicator(customBasketIndicatorRule.evaluate(input));
			
			output
				.getOrCreateNonReportable()
				.setEnrichment(enrichmentDataRule.evaluate(input));
			
			output
				.getOrCreateNonReportable()
				.setPreUpiData(upiPreEnrichmentDataRule.evaluate(input));
			
			output
				.getOrCreateNonReportable()
				.setPostUpiData(upiPostEnrichmentDataRule.evaluate(input));
			
			output
				.getOrCreateNonReportable()
				.setNotionalSchedule(notionalScheduleRule.evaluate(input));
			
			output
				.getOrCreateNonReportable()
				.setUnderlyingAssetType(underlyingAssetTypeRule.evaluate(input));
			
			output
				.getOrCreateNonReportable()
				.setInstrumentType(instrumentTypeRule.evaluate(input));
			
			output
				.getOrCreateNonReportable()
				.setDeliveryType(deliveryTypeRule.evaluate(input));
			
			output
				.getOrCreateNonReportable()
				.setReturnorPayoutTrigger(returnorPayoutTriggerRule.evaluate(input));
			
			output
				.getOrCreateNonReportable()
				.setExecutionVenueType(executionVenueTypeRule.evaluate(input));
			
			output
				.setPlatformAnonymousExecutionIndicator(platformAnonymousExecutionIndicatorRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setSubmittingPartyIDType(dTCC_SubmittingPartyIDTypeRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setSubmittedForParty(dTCC_SubmittedForPartyRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setTradeLegTypes(dTCC_TradeLegTypesRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setTradeParty1ReportingDestination(dTCC_TradeParty1ReportingDestinationRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setPrimaryAssetClass(dTCC_PrimaryAssetClassRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setComment1(null);
			
			output
				.getOrCreateDtccAdditionalFields()
				.setOptionStyle(dTCC_OptionStyleRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setOptionType(dTCC_OptionTypeRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setProductID(dTCC_ProductIDRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setTradeParty2ExecutionAgentID(dTCC_TradeParty2ExecutionAgentIDRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setTradeParty2ExecutionAgentIDType(dTCC_TradeParty2ExecutionAgentIDTypeRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setTradeParty1ExecutionAgentID(dTCC_TradeParty1ExecutionAgentIDRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setTradeParty1ExecutionAgentIDType(dTCC_TradeParty1ExecutionAgentIDTypeRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setTradeParty1TransactionID(dTCC_TradeParty1TransactionIDRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setSettlementType(dTCC_SettlementTypeRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setDeliveryLocation(dTCC_DeliveryLocationRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setResponsibleDataSubmitterIDType(null);
			
			output
				.getOrCreateDtccAdditionalFields()
				.setResponsibleDataSubmitterID(null);
			
			output
				.getOrCreateDtccAdditionalFields()
				.setMaturityDateOfTheUnderlying(dTCC_MaturityDateOfTheUnderlyingRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setCorporateActionNewTradeParty1Lei(null);
			
			output
				.getOrCreateDtccAdditionalFields()
				.setTradeParty1IDType(dTCC_TradeParty1IDTypeRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setUsiID(dTCC_USIIDRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setUsiIDPrefix(null);
			
			output
				.getOrCreateDtccAdditionalFields()
				.setMessageID(dTCC_MessageIDRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setMessageTypePPD(dTCC_MessageTypePPDRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setUnderlyingAsset(dTCC_UnderlyingAssetReportRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setUnderlyingAssetName(dTCC_UnderlyingAssetNameRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setVersionPPD(dTCC_VersionPPDRule.evaluate(input));
			
			return Optional.ofNullable(output)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
