package drr.regulation.csa.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.trade.price.functions.DefaultPercentageToDecimal;
import drr.regulation.csa.rewrite.trade.functions.IsCSALeg2Aligned;
import drr.standards.iosco.cde.base.price.PriceNotationEnum;
import drr.standards.iosco.cde.version3.price.reports.SpreadLeg1NotationEnumRule;
import drr.standards.iosco.cde.version3.price.reports.SpreadLeg2NotationEnumRule;
import javax.inject.Inject;


@ImplementedBy(SpreadNotationLeg2Rule.SpreadNotationLeg2RuleDefault.class)
public abstract class SpreadNotationLeg2Rule implements ReportFunction<TransactionReportInstruction, PriceNotationEnum> {
	
	// RosettaFunction dependencies
	//
	@Inject protected DefaultPercentageToDecimal defaultPercentageToDecimal;
	@Inject protected IsCSALeg2Aligned isCSALeg2Aligned;
	@Inject protected SpreadLeg1NotationEnumRule spreadLeg1NotationEnumRule;
	@Inject protected SpreadLeg2NotationEnumRule spreadLeg2NotationEnumRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public PriceNotationEnum evaluate(TransactionReportInstruction input) {
		PriceNotationEnum output = doEvaluate(input);
		
		return output;
	}

	protected abstract PriceNotationEnum doEvaluate(TransactionReportInstruction input);

	public static class SpreadNotationLeg2RuleDefault extends SpreadNotationLeg2Rule {
		@Override
		protected PriceNotationEnum doEvaluate(TransactionReportInstruction input) {
			PriceNotationEnum output = null;
			return assignOutput(output, input);
		}
		
		protected PriceNotationEnum assignOutput(PriceNotationEnum output, TransactionReportInstruction input) {
			output = MapperS.of(input)
				.mapSingleToItem(item -> {
					final Boolean _boolean = isCSALeg2Aligned.evaluate(item.get());
					if ((_boolean == null ? false : _boolean)) {
						return MapperS.of(defaultPercentageToDecimal.evaluate(spreadLeg2NotationEnumRule.evaluate(item.get()), false));
					}
					return MapperS.of(defaultPercentageToDecimal.evaluate(spreadLeg1NotationEnumRule.evaluate(item.get()), false));
				}).get();
			
			return output;
		}
	}
}
