package drr.regulation.csa.rewrite.trade.validation.datarule;

import cdm.base.staticdata.asset.common.AssetClassEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.csa.rewrite.dtcc.DTCCAdditionalFields;
import drr.regulation.csa.rewrite.trade.CSANonReportable;
import drr.regulation.csa.rewrite.trade.CSATransactionReport;
import drr.standards.iosco.cde.base.price.PriceFormat;
import drr.standards.iosco.cde.base.price.PricePeriod;
import drr.standards.iosco.upi.AnnaDsbAssetClassEnum;
import drr.standards.iosco.upi.AnnaDsbHeader;
import drr.standards.iosco.upi.AnnaDsbUpiRecord;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 6.17.7
 */
@RosettaDataRule("CSATransactionReportCSA_VR_0051_01")
@ImplementedBy(CSATransactionReportCSA_VR_0051_01.Default.class)
public interface CSATransactionReportCSA_VR_0051_01 extends Validator<CSATransactionReport> {
	
	String NAME = "CSATransactionReportCSA_VR_0051_01";
	String DEFINITION = "if dtccAdditionalFields -> messageTypeTransaction exists then (if ([AnnaDsbAssetClassEnum -> Equity, AnnaDsbAssetClassEnum -> Commodities] any = nonReportable -> postUpiData -> Header -> AssetClass or [AssetClassEnum -> Equity, AssetClassEnum -> Commodity] any = dtccAdditionalFields -> primaryAssetClass) and (priceSchedule -> price exists) then (priceSchedule -> endDate exists and if priceSchedule -> endDate count >= 1 then (priceSchedule -> endDate count = priceSchedule -> price count)) else priceSchedule -> endDate is absent)";
	
	class Default implements CSATransactionReportCSA_VR_0051_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CSATransactionReport cSATransactionReport) {
			ComparisonResult result = executeDataRule(cSATransactionReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "CSATransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "CSATransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(CSATransactionReport cSATransactionReport) {
			try {
				if (exists(MapperS.of(cSATransactionReport).<DTCCAdditionalFields>map("getDtccAdditionalFields", _cSATransactionReport -> _cSATransactionReport.getDtccAdditionalFields()).<String>map("getMessageTypeTransaction", dTCCAdditionalFields -> dTCCAdditionalFields.getMessageTypeTransaction())).getOrDefault(false)) {
					if (areEqual(MapperC.<AnnaDsbAssetClassEnum>of(MapperS.of(AnnaDsbAssetClassEnum.EQUITY), MapperS.of(AnnaDsbAssetClassEnum.COMMODITIES)), MapperS.of(cSATransactionReport).<CSANonReportable>map("getNonReportable", _cSATransactionReport -> _cSATransactionReport.getNonReportable()).<AnnaDsbUpiRecord>map("getPostUpiData", cSANonReportable -> cSANonReportable.getPostUpiData()).<AnnaDsbHeader>map("getHeader", annaDsbUpiRecord -> annaDsbUpiRecord.getHeader()).<AnnaDsbAssetClassEnum>map("getAssetClass", annaDsbHeader -> annaDsbHeader.getAssetClass()), CardinalityOperator.Any).or(areEqual(MapperC.<AssetClassEnum>of(MapperS.of(AssetClassEnum.EQUITY), MapperS.of(AssetClassEnum.COMMODITY)), MapperS.of(cSATransactionReport).<DTCCAdditionalFields>map("getDtccAdditionalFields", _cSATransactionReport -> _cSATransactionReport.getDtccAdditionalFields()).<AssetClassEnum>map("getPrimaryAssetClass", dTCCAdditionalFields -> dTCCAdditionalFields.getPrimaryAssetClass()), CardinalityOperator.Any)).and(exists(MapperS.of(cSATransactionReport).<PricePeriod>mapC("getPriceSchedule", _cSATransactionReport -> _cSATransactionReport.getPriceSchedule()).<PriceFormat>map("getPrice", pricePeriod -> pricePeriod.getPrice()))).getOrDefault(false)) {
						final ComparisonResult ifThenElseResult;
						if (greaterThanEquals(MapperS.of(MapperS.of(cSATransactionReport).<PricePeriod>mapC("getPriceSchedule", _cSATransactionReport -> _cSATransactionReport.getPriceSchedule()).<Date>map("getEndDate", pricePeriod -> pricePeriod.getEndDate()).resultCount()), MapperS.of(1), CardinalityOperator.All).getOrDefault(false)) {
							ifThenElseResult = areEqual(MapperS.of(MapperS.of(cSATransactionReport).<PricePeriod>mapC("getPriceSchedule", _cSATransactionReport -> _cSATransactionReport.getPriceSchedule()).<Date>map("getEndDate", pricePeriod -> pricePeriod.getEndDate()).resultCount()), MapperS.of(MapperS.of(cSATransactionReport).<PricePeriod>mapC("getPriceSchedule", _cSATransactionReport -> _cSATransactionReport.getPriceSchedule()).<PriceFormat>map("getPrice", pricePeriod -> pricePeriod.getPrice()).resultCount()), CardinalityOperator.All);
						} else {
							ifThenElseResult = ComparisonResult.successEmptyOperand("");
						}
						return exists(MapperS.of(cSATransactionReport).<PricePeriod>mapC("getPriceSchedule", _cSATransactionReport -> _cSATransactionReport.getPriceSchedule()).<Date>map("getEndDate", pricePeriod -> pricePeriod.getEndDate())).and(ifThenElseResult);
					}
					return notExists(MapperS.of(cSATransactionReport).<PricePeriod>mapC("getPriceSchedule", _cSATransactionReport -> _cSATransactionReport.getPriceSchedule()).<Date>map("getEndDate", pricePeriod -> pricePeriod.getEndDate()));
				}
				return ComparisonResult.successEmptyOperand("");
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements CSATransactionReportCSA_VR_0051_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CSATransactionReport cSATransactionReport) {
			return Collections.emptyList();
		}
	}
}
