package drr.regulation.csa.rewrite.valuation.validation.datarule;

import cdm.base.staticdata.party.PartyIdentifierTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.csa.rewrite.valuation.CSAValuationReport;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 6.17.7
 */
@RosettaDataRule("CSAValuationReportDTCC_CSA_VR_DTCC_02")
@ImplementedBy(CSAValuationReportDTCC_CSA_VR_DTCC_02.Default.class)
public interface CSAValuationReportDTCC_CSA_VR_DTCC_02 extends Validator<CSAValuationReport> {
	
	String NAME = "CSAValuationReportDTCC_CSA_VR_DTCC_02";
	String DEFINITION = "if tradeParty1ExecutionAgentIDType exists then tradeParty1ExecutionAgentID exists";
	
	class Default implements CSAValuationReportDTCC_CSA_VR_DTCC_02 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CSAValuationReport cSAValuationReport) {
			ComparisonResult result = executeDataRule(cSAValuationReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "CSAValuationReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "CSAValuationReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(CSAValuationReport cSAValuationReport) {
			try {
				if (exists(MapperS.of(cSAValuationReport).<PartyIdentifierTypeEnum>map("getTradeParty1ExecutionAgentIDType", _cSAValuationReport -> _cSAValuationReport.getTradeParty1ExecutionAgentIDType())).getOrDefault(false)) {
					return exists(MapperS.of(cSAValuationReport).<String>map("getTradeParty1ExecutionAgentID", _cSAValuationReport -> _cSAValuationReport.getTradeParty1ExecutionAgentID()));
				}
				return ComparisonResult.successEmptyOperand("");
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements CSAValuationReportDTCC_CSA_VR_DTCC_02 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CSAValuationReport cSAValuationReport) {
			return Collections.emptyList();
		}
	}
}
