package drr.regulation.esma.emir.refit.margin.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.util.functions.CompareDateTo;
import drr.regulation.esma.emir.refit.margin.ESMAEMIRMarginReport;
import drr.regulation.esma.emir.refit.margin.PartiesToTheDerivative;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 6.17.7
 */
@RosettaDataRule("ESMAEMIRMarginReportEMIR_VR_3001_04")
@ImplementedBy(ESMAEMIRMarginReportEMIR_VR_3001_04.Default.class)
public interface ESMAEMIRMarginReportEMIR_VR_3001_04 extends Validator<ESMAEMIRMarginReport> {
	
	String NAME = "ESMAEMIRMarginReportEMIR_VR_3001_04";
	String DEFINITION = "CompareDateTo(partiesToTheDerivative -> reportingTimestamp -> date, 2024, 4, 29) >= 0";
	
	class Default implements ESMAEMIRMarginReportEMIR_VR_3001_04 {
	
		@Inject protected CompareDateTo compareDateTo;
		
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, ESMAEMIRMarginReport eSMAEMIRMarginReport) {
			ComparisonResult result = executeDataRule(eSMAEMIRMarginReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "ESMAEMIRMarginReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "ESMAEMIRMarginReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(ESMAEMIRMarginReport eSMAEMIRMarginReport) {
			try {
				return greaterThanEquals(MapperS.of(compareDateTo.evaluate(MapperS.of(eSMAEMIRMarginReport).<PartiesToTheDerivative>map("getPartiesToTheDerivative", _eSMAEMIRMarginReport -> _eSMAEMIRMarginReport.getPartiesToTheDerivative()).<ZonedDateTime>map("getReportingTimestamp", partiesToTheDerivative -> partiesToTheDerivative.getReportingTimestamp()).<Date>map("Date", zdt -> Date.of(zdt.toLocalDate())).get(), 2024, 4, 29)), MapperS.of(0), CardinalityOperator.All);
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements ESMAEMIRMarginReportEMIR_VR_3001_04 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, ESMAEMIRMarginReport eSMAEMIRMarginReport) {
			return Collections.emptyList();
		}
	}
}
