package drr.regulation.esma.emir.refit.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.IsCapFloor;
import drr.regulation.common.functions.ProductForEvent;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(OptionPremiumPaymentDateRule.OptionPremiumPaymentDateRuleDefault.class)
public abstract class OptionPremiumPaymentDateRule implements ReportFunction<TransactionReportInstruction, Date> {
	
	// RosettaFunction dependencies
	//
	@Inject protected EffectiveDateRule effectiveDateRule;
	@Inject protected IsCapFloor isCapFloor;
	@Inject protected drr.standards.iosco.cde.version3.price.reports.OptionPremiumPaymentDateRule optionPremiumPaymentDateRule;
	@Inject protected ProductForEvent productForEvent;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public Date evaluate(TransactionReportInstruction input) {
		Date output = doEvaluate(input);
		
		return output;
	}

	protected abstract Date doEvaluate(TransactionReportInstruction input);

	public static class OptionPremiumPaymentDateRuleDefault extends OptionPremiumPaymentDateRule {
		@Override
		protected Date doEvaluate(TransactionReportInstruction input) {
			Date output = null;
			return assignOutput(output, input);
		}
		
		protected Date assignOutput(Date output, TransactionReportInstruction input) {
			if (exists(MapperS.of(optionPremiumPaymentDateRule.evaluate(input))).getOrDefault(false)) {
				output = optionPremiumPaymentDateRule.evaluate(input);
			} else {
				final Boolean _boolean = isCapFloor.evaluate(productForEvent.evaluate(input));
				if ((_boolean == null ? false : _boolean)) {
					output = effectiveDateRule.evaluate(input);
				} else {
					output = null;
				}
			}
			
			return output;
		}
	}
}
