package drr.regulation.fca.ukemir.refit.trade.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import drr.regulation.common.CommonTransactionInformation;
import drr.regulation.common.RegimeNameEnum;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.SupervisoryBodyEnum;
import drr.regulation.common.TradableOnTradingVenueEnum;
import drr.regulation.common.TransactionInformation;
import drr.regulation.common.functions.GetExecutionTimestamp;
import drr.regulation.common.functions.GetIsin;
import drr.regulation.common.functions.GetTransactionInformationForRegime;
import drr.regulation.common.functions.ProductForEvent;
import drr.standards.iso.MicData;
import drr.standards.iso.MicTypeEnum;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(UKEMIR_Venue.UKEMIR_VenueDefault.class)
public abstract class UKEMIR_Venue implements RosettaFunction {
	
	// RosettaFunction dependencies
	//
	@Inject protected GetExecutionTimestamp getExecutionTimestamp;
	@Inject protected GetIsin getIsin;
	@Inject protected GetMicDataForFacility getMicDataForFacility;
	@Inject protected GetTransactionInformationForRegime getTransactionInformationForRegime;
	@Inject protected IsSI isSI;
	@Inject protected IsUKEmirTradingVenue isUKEmirTradingVenue;
	@Inject protected ProductForEvent productForEvent;

	/**
	* @param reportableEvent 
	* @return venue 
	*/
	public String evaluate(ReportableEvent reportableEvent) {
		String venue = doEvaluate(reportableEvent);
		
		return venue;
	}

	protected abstract String doEvaluate(ReportableEvent reportableEvent);

	protected abstract MapperS<? extends MicData> micDataForFacility(ReportableEvent reportableEvent);

	protected abstract MapperS<String> venueMic(ReportableEvent reportableEvent);

	protected abstract MapperS<Boolean> transactionHasIsin(ReportableEvent reportableEvent);

	protected abstract MapperS<? extends TransactionInformation> transactionInformation(ReportableEvent reportableEvent);

	protected abstract MapperS<Boolean> isinTotv(ReportableEvent reportableEvent);

	protected abstract MapperS<Boolean> uIsinTotv(ReportableEvent reportableEvent);

	protected abstract MapperS<String> transactionValidMic(ReportableEvent reportableEvent);

	public static class UKEMIR_VenueDefault extends UKEMIR_Venue {
		@Override
		protected String doEvaluate(ReportableEvent reportableEvent) {
			String venue = null;
			return assignOutput(venue, reportableEvent);
		}
		
		protected String assignOutput(String venue, ReportableEvent reportableEvent) {
			if (exists(transactionValidMic(reportableEvent)).getOrDefault(false)) {
				venue = transactionValidMic(reportableEvent).get();
			} else if (isinTotv(reportableEvent).getOrDefault(false)) {
				venue = "XOFF";
			} else {
				venue = "XXXX";
			}
			
			return venue;
		}
		
		@Override
		protected MapperS<? extends MicData> micDataForFacility(ReportableEvent reportableEvent) {
			return MapperS.of(getMicDataForFacility.evaluate(MapperS.of(reportableEvent).<ReportableInformation>map("getReportableInformation", _reportableEvent -> _reportableEvent.getReportableInformation()).get()));
		}
		
		@Override
		protected MapperS<String> venueMic(ReportableEvent reportableEvent) {
			final MapperS<? extends MicData> thenArg = micDataForFacility(reportableEvent);
			return thenArg
				.mapSingleToItem(item -> {
					if (areEqual(item.<String>map("getStatus", micData -> micData.getStatus()), MapperS.of("EXPIRED"), CardinalityOperator.All).and(lessThanEquals(item.<Date>map("getExpiryDate", micData -> micData.getExpiryDate()), MapperS.of(getExecutionTimestamp.evaluate(reportableEvent)).<Date>map("Date", zdt -> Date.of(zdt.toLocalDate())), CardinalityOperator.All)).or(notEqual(item.<String>map("getStatus", micData -> micData.getStatus()), MapperS.of("EXPIRED"), CardinalityOperator.Any)).getOrDefault(false)) {
						if (areEqual(item.<MicTypeEnum>map("getMicType", micData -> micData.getMicType()), MapperS.of(MicTypeEnum.SGMT), CardinalityOperator.All).getOrDefault(false)) {
							return item.<String>map("getMic", micData -> micData.getMic());
						}
						return item.<String>map("getOperatingMic", micData -> micData.getOperatingMic());
					}
					return MapperS.<String>ofNull();
				});
		}
		
		@Override
		protected MapperS<Boolean> transactionHasIsin(ReportableEvent reportableEvent) {
			return exists(MapperS.of(getIsin.evaluate(productForEvent.evaluate(reportableEvent)))).asMapper();
		}
		
		@Override
		protected MapperS<? extends TransactionInformation> transactionInformation(ReportableEvent reportableEvent) {
			return MapperS.of(getTransactionInformationForRegime.evaluate(reportableEvent, RegimeNameEnum.UKEMIR, SupervisoryBodyEnum.FCA));
		}
		
		@Override
		protected MapperS<Boolean> isinTotv(ReportableEvent reportableEvent) {
			return MapperS.of(areEqual(transactionInformation(reportableEvent).<CommonTransactionInformation>map("getFcaTransactionInformation", _transactionInformation -> _transactionInformation.getFcaTransactionInformation()).<TradableOnTradingVenueEnum>map("getTradableOnTradingVenue", commonTransactionInformation -> commonTransactionInformation.getTradableOnTradingVenue()), MapperS.of(TradableOnTradingVenueEnum.ADMITTED), CardinalityOperator.All).getOrDefault(false));
		}
		
		@Override
		protected MapperS<Boolean> uIsinTotv(ReportableEvent reportableEvent) {
			return MapperS.of(transactionInformation(reportableEvent).<CommonTransactionInformation>map("getFcaTransactionInformation", _transactionInformation -> _transactionInformation.getFcaTransactionInformation()).<Boolean>map("getUnderlierTradedOnTradingVenue", commonTransactionInformation -> commonTransactionInformation.getUnderlierTradedOnTradingVenue()).getOrDefault(false));
		}
		
		@Override
		protected MapperS<String> transactionValidMic(ReportableEvent reportableEvent) {
			if (exists(venueMic(reportableEvent)).getOrDefault(false)) {
				final Boolean boolean0 = isUKEmirTradingVenue.evaluate(micDataForFacility(reportableEvent).get());
				if ((boolean0 == null ? false : boolean0)) {
					return venueMic(reportableEvent);
				}
				final Boolean boolean1 = isSI.evaluate(micDataForFacility(reportableEvent).get());
				if ((boolean1 == null ? false : boolean1)) {
					if (ComparisonResult.of(isinTotv(reportableEvent)).or(ComparisonResult.of(uIsinTotv(reportableEvent))).getOrDefault(false)) {
						return venueMic(reportableEvent);
					}
					return MapperS.of("XXXX");
				}
				return venueMic(reportableEvent);
			}
			return MapperS.<String>ofNull();
		}
	}
}
