package drr.regulation.fca.ukemir.refit.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.IsAllowableAction;
import drr.regulation.common.trade.party.reports.ExecutionAgentCounterparty2Rule;
import javax.inject.Inject;


@ImplementedBy(ExecutionAgentReportingCounterpartyRule.ExecutionAgentReportingCounterpartyRuleDefault.class)
public abstract class ExecutionAgentReportingCounterpartyRule implements ReportFunction<TransactionReportInstruction, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected ExecutionAgentCounterparty2Rule executionAgentCounterparty2Rule;
	@Inject protected IsAllowableAction isAllowableAction;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(TransactionReportInstruction input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(TransactionReportInstruction input);

	public static class ExecutionAgentReportingCounterpartyRuleDefault extends ExecutionAgentReportingCounterpartyRule {
		@Override
		protected String doEvaluate(TransactionReportInstruction input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableAction.evaluate(item.get()));
			output = MapperS.of(executionAgentCounterparty2Rule.evaluate(thenArg.get())).get();
			
			return output;
		}
	}
}
