package drr.regulation.fca.ukemir.refit.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.fca.ukemir.refit.trade.FCAUKEMIRNonReportable;
import drr.regulation.fca.ukemir.refit.trade.FCAUKEMIRTransactionReport;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 6.17.7
 */
@RosettaDataRule("FCAUKEMIRTransactionReportUKEMIR_VR_1021_02")
@ImplementedBy(FCAUKEMIRTransactionReportUKEMIR_VR_1021_02.Default.class)
public interface FCAUKEMIRTransactionReportUKEMIR_VR_1021_02 extends Validator<FCAUKEMIRTransactionReport> {
	
	String NAME = "FCAUKEMIRTransactionReportUKEMIR_VR_1021_02";
	String DEFINITION = "if (executionAgentCounterparty1 exists and executionAgentCounterparty2 is absent) or (executionAgentCounterparty1 is absent and executionAgentCounterparty2 exists) then nonReportable -> relationshipRecord exists";
	
	class Default implements FCAUKEMIRTransactionReportUKEMIR_VR_1021_02 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, FCAUKEMIRTransactionReport fCAUKEMIRTransactionReport) {
			ComparisonResult result = executeDataRule(fCAUKEMIRTransactionReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "FCAUKEMIRTransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "FCAUKEMIRTransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(FCAUKEMIRTransactionReport fCAUKEMIRTransactionReport) {
			try {
				if (exists(MapperS.of(fCAUKEMIRTransactionReport).<String>map("getExecutionAgentCounterparty1", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getExecutionAgentCounterparty1())).and(notExists(MapperS.of(fCAUKEMIRTransactionReport).<String>map("getExecutionAgentCounterparty2", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getExecutionAgentCounterparty2()))).or(notExists(MapperS.of(fCAUKEMIRTransactionReport).<String>map("getExecutionAgentCounterparty1", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getExecutionAgentCounterparty1())).and(exists(MapperS.of(fCAUKEMIRTransactionReport).<String>map("getExecutionAgentCounterparty2", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getExecutionAgentCounterparty2())))).getOrDefault(false)) {
					return exists(MapperS.of(fCAUKEMIRTransactionReport).<FCAUKEMIRNonReportable>map("getNonReportable", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getNonReportable()).<String>map("getRelationshipRecord", fCAUKEMIRNonReportable -> fCAUKEMIRNonReportable.getRelationshipRecord()));
				}
				return ComparisonResult.successEmptyOperand("");
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements FCAUKEMIRTransactionReportUKEMIR_VR_1021_02 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, FCAUKEMIRTransactionReport fCAUKEMIRTransactionReport) {
			return Collections.emptyList();
		}
	}
}
