package drr.regulation.hkma.rewrite.trade.functions;

import cdm.base.staticdata.identifier.TradeIdentifierTypeEnum;
import cdm.event.common.TradeIdentifier;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.functions.TradeForEvent;
import java.util.Optional;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(Extract_UTIPropietary.Extract_UTIPropietaryDefault.class)
public abstract class Extract_UTIPropietary implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected TradeForEvent tradeForEvent;

	/**
	* @param reportableEvent 
	* @return tradeIdentifier 
	*/
	public TradeIdentifier evaluate(ReportableEvent reportableEvent) {
		TradeIdentifier.TradeIdentifierBuilder tradeIdentifierBuilder = doEvaluate(reportableEvent);
		
		final TradeIdentifier tradeIdentifier;
		if (tradeIdentifierBuilder == null) {
			tradeIdentifier = null;
		} else {
			tradeIdentifier = tradeIdentifierBuilder.build();
			objectValidator.validate(TradeIdentifier.class, tradeIdentifier);
		}
		
		return tradeIdentifier;
	}

	protected abstract TradeIdentifier.TradeIdentifierBuilder doEvaluate(ReportableEvent reportableEvent);

	public static class Extract_UTIPropietaryDefault extends Extract_UTIPropietary {
		@Override
		protected TradeIdentifier.TradeIdentifierBuilder doEvaluate(ReportableEvent reportableEvent) {
			TradeIdentifier.TradeIdentifierBuilder tradeIdentifier = TradeIdentifier.builder();
			return assignOutput(tradeIdentifier, reportableEvent);
		}
		
		protected TradeIdentifier.TradeIdentifierBuilder assignOutput(TradeIdentifier.TradeIdentifierBuilder tradeIdentifier, ReportableEvent reportableEvent) {
			final MapperS<ReportableEvent> thenArg0 = MapperS.of(reportableEvent);
			final MapperC<TradeIdentifier> thenArg1 = thenArg0
				.mapSingleToList(item -> {
					if (exists(MapperS.of(tradeForEvent.evaluate(item.get()))).getOrDefault(false)) {
						return MapperS.of(tradeForEvent.evaluate(item.get())).<TradeIdentifier>mapC("getTradeIdentifier", trade -> trade.getTradeIdentifier());
					}
					return MapperC.<TradeIdentifier>ofNull();
				});
			final MapperC<TradeIdentifier> thenArg2 = thenArg1
				.filterItemNullSafe(item -> areEqual(item.<TradeIdentifierTypeEnum>map("getIdentifierType", _tradeIdentifier -> _tradeIdentifier.getIdentifierType()), MapperS.of(TradeIdentifierTypeEnum.UNIQUE_SWAP_IDENTIFIER), CardinalityOperator.All).or(notExists(item.<TradeIdentifierTypeEnum>map("getIdentifierType", _tradeIdentifier -> _tradeIdentifier.getIdentifierType()))).get());
			final MapperC<TradeIdentifier> thenArg3 = distinct(thenArg2);
			tradeIdentifier = toBuilder(MapperS.of(thenArg3.get()).get());
			
			return Optional.ofNullable(tradeIdentifier)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
