package drr.regulation.hkma.rewrite.trade.reports;

import cdm.product.template.BasketConstituent;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import javax.inject.Inject;


@ImplementedBy(BasketConstituentIdentifierRule.BasketConstituentIdentifierRuleDefault.class)
public abstract class BasketConstituentIdentifierRule implements ReportFunction<BasketConstituent, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected drr.regulation.common.trade.basket.reports.BasketConstituentIdentifierRule basketConstituentIdentifierRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(BasketConstituent input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(BasketConstituent input);

	public static class BasketConstituentIdentifierRuleDefault extends BasketConstituentIdentifierRule {
		@Override
		protected String doEvaluate(BasketConstituent input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, BasketConstituent input) {
			final FieldWithMetaString fieldWithMetaString = MapperS.of(input)
				.mapSingleToItem(item -> {
					final String string = basketConstituentIdentifierRule.evaluate(item.get());
					return string == null ? MapperS.<FieldWithMetaString>ofNull() : MapperS.of(FieldWithMetaString.builder().setValue(string).build());
				}).get();
			if (fieldWithMetaString == null) {
				output = null;
			} else {
				output = fieldWithMetaString.getValue();
			}
			
			return output;
		}
	}
}
