package drr.standards.iosco.cde.version1.basket.reports;

import cdm.base.staticdata.asset.common.ProductIdentifier;
import cdm.event.common.Trade;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.functions.TradeForEvent;
import drr.standards.iosco.cde.base.basket.functions.GetBasketConstituentsProductIdentifier;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;


@ImplementedBy(IdentifierOfBasketConstituentsRule.IdentifierOfBasketConstituentsRuleDefault.class)
public abstract class IdentifierOfBasketConstituentsRule implements ReportFunction<ReportableEvent, List<String>> {
	
	// RosettaFunction dependencies
	//
	@Inject protected GetBasketConstituentsProductIdentifier getBasketConstituentsProductIdentifier;
	@Inject protected TradeForEvent tradeForEvent;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public List<String> evaluate(ReportableEvent input) {
		List<String> output = doEvaluate(input);
		
		return output;
	}

	protected abstract List<String> doEvaluate(ReportableEvent input);

	public static class IdentifierOfBasketConstituentsRuleDefault extends IdentifierOfBasketConstituentsRule {
		@Override
		protected List<String> doEvaluate(ReportableEvent input) {
			List<String> output = new ArrayList<>();
			return assignOutput(output, input);
		}
		
		protected List<String> assignOutput(List<String> output, ReportableEvent input) {
			final MapperS<Trade> thenArg = MapperS.of(input)
				.mapSingleToItem(item -> MapperS.of(tradeForEvent.evaluate(item.get())));
			output = thenArg
				.mapSingleToList(item -> MapperC.<ProductIdentifier>of(getBasketConstituentsProductIdentifier.evaluate(item.get())).<FieldWithMetaString>map("getIdentifier", productIdentifier -> productIdentifier.getIdentifier())).<String>map("Type coercion", fieldWithMetaString -> fieldWithMetaString.getValue()).getMulti();
			
			return output;
		}
	}
}
