package drr.standards.iosco.cde.version1.payment.reports;

import cdm.base.datetime.Frequency;
import cdm.product.asset.InterestRatePayout;
import cdm.product.common.schedule.PaymentDates;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.functions.AdjustPeriodMultiplier;
import drr.regulation.common.functions.FormatToMax3Number;
import java.math.BigDecimal;
import javax.inject.Inject;


@ImplementedBy(PaymentFrequencyPeriodMultiplierAdjustedRule.PaymentFrequencyPeriodMultiplierAdjustedRuleDefault.class)
public abstract class PaymentFrequencyPeriodMultiplierAdjustedRule implements ReportFunction<InterestRatePayout, BigDecimal> {
	
	// RosettaFunction dependencies
	//
	@Inject protected AdjustPeriodMultiplier adjustPeriodMultiplier;
	@Inject protected FormatToMax3Number formatToMax3Number;
	@Inject protected PaymentFrequencyPeriodRule paymentFrequencyPeriodRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public BigDecimal evaluate(InterestRatePayout input) {
		BigDecimal output = doEvaluate(input);
		
		return output;
	}

	protected abstract BigDecimal doEvaluate(InterestRatePayout input);

	public static class PaymentFrequencyPeriodMultiplierAdjustedRuleDefault extends PaymentFrequencyPeriodMultiplierAdjustedRule {
		@Override
		protected BigDecimal doEvaluate(InterestRatePayout input) {
			BigDecimal output = null;
			return assignOutput(output, input);
		}
		
		protected BigDecimal assignOutput(BigDecimal output, InterestRatePayout input) {
			final MapperS<BigDecimal> thenArg = MapperS.of(input)
				.mapSingleToItem(item -> {
					final Integer integer = item.<PaymentDates>map("getPaymentDates", interestRatePayout -> interestRatePayout.getPaymentDates()).<Frequency>map("getPaymentFrequency", paymentDates -> paymentDates.getPaymentFrequency()).<Integer>map("getPeriodMultiplier", frequency -> frequency.getPeriodMultiplier()).get();
					return MapperS.of(adjustPeriodMultiplier.evaluate(paymentFrequencyPeriodRule.evaluate(item.get()), (integer == null ? null : BigDecimal.valueOf(integer))));
				});
			output = MapperS.of(formatToMax3Number.evaluate(thenArg.get())).get();
			
			return output;
		}
	}
}
