package drr.standards.iosco.cde.version1.price.functions;

import cdm.observable.asset.PriceSchedule;
import cdm.product.asset.CommodityPayout;
import cdm.product.qualification.functions.Qualify_Commodity_Forward;
import cdm.product.qualification.functions.Qualify_Commodity_Option;
import cdm.product.qualification.functions.Qualify_Commodity_Swap_Basis;
import cdm.product.qualification.functions.Qualify_Commodity_Swap_FixedFloat;
import cdm.product.qualification.functions.Qualify_Commodity_Swaption;
import cdm.product.template.CalculationSchedule;
import cdm.product.template.ForwardPayout;
import cdm.product.template.OptionPayout;
import cdm.product.template.Payout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.functions.EconomicTermsForProduct;
import drr.regulation.common.functions.ProductForEvent;
import drr.standards.iosco.cde.base.price.PriceNotationEnum;
import drr.standards.iosco.cde.base.price.PricePeriod;
import drr.standards.iosco.cde.base.price.functions.Contract_Price;
import drr.standards.iosco.cde.base.price.functions.GetReportableSchedulePeriod;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;


@ImplementedBy(GetReportablePricePeriod.GetReportablePricePeriodDefault.class)
public abstract class GetReportablePricePeriod implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected Contract_Price contract_Price;
	@Inject protected EconomicTermsForProduct economicTermsForProduct;
	@Inject protected GetReportableSchedulePeriod getReportableSchedulePeriod;
	@Inject protected ProductForEvent productForEvent;
	@Inject protected Qualify_Commodity_Forward qualify_Commodity_Forward;
	@Inject protected Qualify_Commodity_Option qualify_Commodity_Option;
	@Inject protected Qualify_Commodity_Swap_Basis qualify_Commodity_Swap_Basis;
	@Inject protected Qualify_Commodity_Swap_FixedFloat qualify_Commodity_Swap_FixedFloat;
	@Inject protected Qualify_Commodity_Swaption qualify_Commodity_Swaption;

	/**
	* @param reportableEvent 
	* @param notation 
	* @return reportablePeriod 
	*/
	public List<? extends PricePeriod> evaluate(ReportableEvent reportableEvent, PriceNotationEnum notation) {
		List<PricePeriod.PricePeriodBuilder> reportablePeriodBuilder = doEvaluate(reportableEvent, notation);
		
		final List<? extends PricePeriod> reportablePeriod;
		if (reportablePeriodBuilder == null) {
			reportablePeriod = null;
		} else {
			reportablePeriod = reportablePeriodBuilder.stream().map(PricePeriod::build).collect(Collectors.toList());
			objectValidator.validate(PricePeriod.class, reportablePeriod);
		}
		
		return reportablePeriod;
	}

	protected abstract List<PricePeriod.PricePeriodBuilder> doEvaluate(ReportableEvent reportableEvent, PriceNotationEnum notation);

	protected abstract MapperS<? extends CalculationSchedule> customizedSchedule(ReportableEvent reportableEvent, PriceNotationEnum notation);

	protected abstract MapperS<? extends PriceSchedule> priceSchedule(ReportableEvent reportableEvent, PriceNotationEnum notation);

	public static class GetReportablePricePeriodDefault extends GetReportablePricePeriod {
		@Override
		protected List<PricePeriod.PricePeriodBuilder> doEvaluate(ReportableEvent reportableEvent, PriceNotationEnum notation) {
			List<PricePeriod.PricePeriodBuilder> reportablePeriod = new ArrayList<>();
			return assignOutput(reportablePeriod, reportableEvent, notation);
		}
		
		protected List<PricePeriod.PricePeriodBuilder> assignOutput(List<PricePeriod.PricePeriodBuilder> reportablePeriod, ReportableEvent reportableEvent, PriceNotationEnum notation) {
			reportablePeriod.addAll(toBuilder(getReportableSchedulePeriod.evaluate(priceSchedule(reportableEvent, notation).get(), customizedSchedule(reportableEvent, notation).get(), notation)));
			
			return Optional.ofNullable(reportablePeriod)
				.map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList()))
				.orElse(null);
		}
		
		@Override
		protected MapperS<? extends CalculationSchedule> customizedSchedule(ReportableEvent reportableEvent, PriceNotationEnum notation) {
			if (ComparisonResult.of(MapperS.of(qualify_Commodity_Swap_FixedFloat.evaluate(economicTermsForProduct.evaluate(productForEvent.evaluate(reportableEvent))))).or(ComparisonResult.of(MapperS.of(qualify_Commodity_Swap_Basis.evaluate(economicTermsForProduct.evaluate(productForEvent.evaluate(reportableEvent)))))).getOrDefault(false)) {
				return MapperS.of(economicTermsForProduct.evaluate(productForEvent.evaluate(reportableEvent))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CommodityPayout>mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).<CalculationSchedule>map("getSchedule", commodityPayout -> commodityPayout.getSchedule())
					.first();
			}
			if (ComparisonResult.of(MapperS.of(qualify_Commodity_Option.evaluate(economicTermsForProduct.evaluate(productForEvent.evaluate(reportableEvent))))).or(ComparisonResult.of(MapperS.of(qualify_Commodity_Swaption.evaluate(economicTermsForProduct.evaluate(productForEvent.evaluate(reportableEvent)))))).getOrDefault(false)) {
				return MapperS.of(MapperS.of(economicTermsForProduct.evaluate(productForEvent.evaluate(reportableEvent))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).get()).<CalculationSchedule>map("getSchedule", optionPayout -> optionPayout.getSchedule());
			}
			final Boolean _boolean = qualify_Commodity_Forward.evaluate(economicTermsForProduct.evaluate(productForEvent.evaluate(reportableEvent)));
			if ((_boolean == null ? false : _boolean)) {
				return MapperS.of(MapperS.of(economicTermsForProduct.evaluate(productForEvent.evaluate(reportableEvent))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<ForwardPayout>mapC("getForwardPayout", payout -> payout.getForwardPayout()).get()).<CalculationSchedule>map("getSchedule", forwardPayout -> forwardPayout.getSchedule());
			}
			return MapperS.<CalculationSchedule>ofNull();
		}
		
		@Override
		protected MapperS<? extends PriceSchedule> priceSchedule(ReportableEvent reportableEvent, PriceNotationEnum notation) {
			return MapperS.of(MapperC.of(contract_Price.evaluate(reportableEvent)).get());
		}
	}
}
