package drr.standards.iosco.cde.version1.price.reports;

import cdm.observable.asset.PriceSchedule;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.standards.iosco.cde.base.price.functions.Contract_StrikePrice;
import java.math.BigDecimal;
import javax.inject.Inject;


@ImplementedBy(StrikePriceNoFormatRule.StrikePriceNoFormatRuleDefault.class)
public abstract class StrikePriceNoFormatRule implements ReportFunction<TransactionReportInstruction, BigDecimal> {
	
	// RosettaFunction dependencies
	//
	@Inject protected Contract_StrikePrice contract_StrikePrice;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public BigDecimal evaluate(TransactionReportInstruction input) {
		BigDecimal output = doEvaluate(input);
		
		return output;
	}

	protected abstract BigDecimal doEvaluate(TransactionReportInstruction input);

	public static class StrikePriceNoFormatRuleDefault extends StrikePriceNoFormatRule {
		@Override
		protected BigDecimal doEvaluate(TransactionReportInstruction input) {
			BigDecimal output = null;
			return assignOutput(output, input);
		}
		
		protected BigDecimal assignOutput(BigDecimal output, TransactionReportInstruction input) {
			output = MapperC.<PriceSchedule>of(contract_StrikePrice.evaluate(input)).<BigDecimal>map("getValue", priceSchedule -> priceSchedule.getValue()).get();
			
			return output;
		}
	}
}
