package drr.standards.iosco.cde.version1.quantity.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.PayoutLegWithAuxiliary;
import drr.standards.iosco.cde.base.quantity.functions.NotionalLeg;
import java.math.BigDecimal;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(NotionalAmount.NotionalAmountDefault.class)
public abstract class NotionalAmount implements RosettaFunction {
	
	// RosettaFunction dependencies
	//
	@Inject protected NotionalLeg notionalLeg;

	/**
	* @param payout 
	* @param defaultValue 
	* @return notionalAmount 
	*/
	public BigDecimal evaluate(PayoutLegWithAuxiliary payout, BigDecimal defaultValue) {
		BigDecimal notionalAmount = doEvaluate(payout, defaultValue);
		
		return notionalAmount;
	}

	protected abstract BigDecimal doEvaluate(PayoutLegWithAuxiliary payout, BigDecimal defaultValue);

	public static class NotionalAmountDefault extends NotionalAmount {
		@Override
		protected BigDecimal doEvaluate(PayoutLegWithAuxiliary payout, BigDecimal defaultValue) {
			BigDecimal notionalAmount = null;
			return assignOutput(notionalAmount, payout, defaultValue);
		}
		
		protected BigDecimal assignOutput(BigDecimal notionalAmount, PayoutLegWithAuxiliary payout, BigDecimal defaultValue) {
			notionalAmount = MapperS.of(payout)
				.mapSingleToItem(item -> {
					if (areEqual(MapperS.of(notionalLeg.evaluate(item.get())).<BigDecimal>map("getValue", measure -> measure.getValue()), MapperS.of(BigDecimal.valueOf(0)), CardinalityOperator.All).and(areEqual(item.<Boolean>map("getZeroNotionalAmountDefaulting", payoutLegWithAuxiliary -> payoutLegWithAuxiliary.getZeroNotionalAmountDefaulting()), MapperS.of(true), CardinalityOperator.All)).getOrDefault(false)) {
						return MapperS.of(defaultValue);
					}
					return MapperS.of(notionalLeg.evaluate(item.get())).<BigDecimal>map("getValue", measure -> measure.getValue());
				}).get();
			
			return notionalAmount;
		}
	}
}
