package drr.standards.iosco.cde.version3.collateral.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.CollateralReportInstruction;
import drr.standards.iso.CollateralisationType3Code__1;
import javax.inject.Inject;


@ImplementedBy(CollateralisationCategoryRule.CollateralisationCategoryRuleDefault.class)
public abstract class CollateralisationCategoryRule implements ReportFunction<CollateralReportInstruction, CollateralisationType3Code__1> {
	
	// RosettaFunction dependencies
	//
	@Inject protected drr.standards.iosco.cde.version2.collateral.reports.CollateralisationCategoryRule collateralisationCategoryRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public CollateralisationType3Code__1 evaluate(CollateralReportInstruction input) {
		CollateralisationType3Code__1 output = doEvaluate(input);
		
		return output;
	}

	protected abstract CollateralisationType3Code__1 doEvaluate(CollateralReportInstruction input);

	public static class CollateralisationCategoryRuleDefault extends CollateralisationCategoryRule {
		@Override
		protected CollateralisationType3Code__1 doEvaluate(CollateralReportInstruction input) {
			CollateralisationType3Code__1 output = null;
			return assignOutput(output, input);
		}
		
		protected CollateralisationType3Code__1 assignOutput(CollateralisationType3Code__1 output, CollateralReportInstruction input) {
			output = collateralisationCategoryRule.evaluate(input);
			
			return output;
		}
	}
}
