package drr.standards.iosco.cde.version3.event.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.functions.PositionForEvent;
import drr.regulation.common.functions.TradeForEvent;
import drr.standards.iso.ReportLevelEnum;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(LevelRule.LevelRuleDefault.class)
public abstract class LevelRule implements ReportFunction<ReportableEvent, ReportLevelEnum> {
	
	// RosettaFunction dependencies
	//
	@Inject protected PositionForEvent positionForEvent;
	@Inject protected TradeForEvent tradeForEvent;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public ReportLevelEnum evaluate(ReportableEvent input) {
		ReportLevelEnum output = doEvaluate(input);
		
		return output;
	}

	protected abstract ReportLevelEnum doEvaluate(ReportableEvent input);

	public static class LevelRuleDefault extends LevelRule {
		@Override
		protected ReportLevelEnum doEvaluate(ReportableEvent input) {
			ReportLevelEnum output = null;
			return assignOutput(output, input);
		}
		
		protected ReportLevelEnum assignOutput(ReportLevelEnum output, ReportableEvent input) {
			if (exists(MapperS.of(tradeForEvent.evaluate(input))).getOrDefault(false)) {
				output = MapperS.of(input)
					.mapSingleToItem(item -> MapperS.of(ReportLevelEnum.TCTN)).get();
			} else if (exists(MapperS.of(positionForEvent.evaluate(input))).getOrDefault(false)) {
				output = MapperS.of(input)
					.mapSingleToItem(item -> MapperS.of(ReportLevelEnum.PSTN)).get();
			} else {
				output = null;
			}
			
			return output;
		}
	}
}
