package drr.standards.iosco.cde.version3.payment.reports;

import cdm.product.asset.InterestRatePayout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.standards.iso.FrequencyPeriodEnum;
import javax.inject.Inject;


@ImplementedBy(PaymentFrequencyPeriodAdjustedRule.PaymentFrequencyPeriodAdjustedRuleDefault.class)
public abstract class PaymentFrequencyPeriodAdjustedRule implements ReportFunction<InterestRatePayout, FrequencyPeriodEnum> {
	
	// RosettaFunction dependencies
	//
	@Inject protected drr.standards.iosco.cde.version2.payment.reports.PaymentFrequencyPeriodAdjustedRule paymentFrequencyPeriodAdjustedRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public FrequencyPeriodEnum evaluate(InterestRatePayout input) {
		FrequencyPeriodEnum output = doEvaluate(input);
		
		return output;
	}

	protected abstract FrequencyPeriodEnum doEvaluate(InterestRatePayout input);

	public static class PaymentFrequencyPeriodAdjustedRuleDefault extends PaymentFrequencyPeriodAdjustedRule {
		@Override
		protected FrequencyPeriodEnum doEvaluate(InterestRatePayout input) {
			FrequencyPeriodEnum output = null;
			return assignOutput(output, input);
		}
		
		protected FrequencyPeriodEnum assignOutput(FrequencyPeriodEnum output, InterestRatePayout input) {
			output = paymentFrequencyPeriodAdjustedRule.evaluate(input);
			
			return output;
		}
	}
}
