package drr.standards.iosco.cde.version3.quantity.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import javax.inject.Inject;


@ImplementedBy(QuantityUnitOfMeasureLeg1Rule.QuantityUnitOfMeasureLeg1RuleDefault.class)
public abstract class QuantityUnitOfMeasureLeg1Rule implements ReportFunction<TransactionReportInstruction, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected drr.standards.iosco.cde.version2.quantity.reports.QuantityUnitOfMeasureLeg1Rule quantityUnitOfMeasureLeg1Rule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(TransactionReportInstruction input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(TransactionReportInstruction input);

	public static class QuantityUnitOfMeasureLeg1RuleDefault extends QuantityUnitOfMeasureLeg1Rule {
		@Override
		protected String doEvaluate(TransactionReportInstruction input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, TransactionReportInstruction input) {
			output = quantityUnitOfMeasureLeg1Rule.evaluate(input);
			
			return output;
		}
	}
}
