package iso20022.auth030.hkma.tr.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import iso20022.auth030.hkma.tr.FloatingRateIdentification8Choice__1;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkString;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.Optional.empty;
import static java.util.Optional.of;
import static java.util.stream.Collectors.toList;

public class FloatingRateIdentification8Choice__1TypeFormatValidator implements Validator<FloatingRateIdentification8Choice__1> {

	private List<ComparisonResult> getComparisonResults(FloatingRateIdentification8Choice__1 o) {
		return Lists.<ComparisonResult>newArrayList(
				checkString("cd", o.getCd(), 1, of(4), empty())
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, FloatingRateIdentification8Choice__1 o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("FloatingRateIdentification8Choice__1", ValidationResult.ValidationType.TYPE_FORMAT, "FloatingRateIdentification8Choice__1", path, "", res.getError());
				}
				return success("FloatingRateIdentification8Choice__1", ValidationResult.ValidationType.TYPE_FORMAT, "FloatingRateIdentification8Choice__1", path, "");
			})
			.collect(toList());
	}

}
