package iso20022.auth030.hkma.tr.validation.exists;

import com.google.common.collect.ImmutableMap;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ExistenceChecker;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import iso20022.auth030.hkma.tr.AssetClassCommodityInflation1;
import iso20022.auth030.hkma.tr.AssetClassProductType12Code;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;

public class AssetClassCommodityInflation1OnlyExistsValidator implements ValidatorWithArg<AssetClassCommodityInflation1, Set<String>> {

	/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
	@Override
	public <T2 extends AssetClassCommodityInflation1> ValidationResult<AssetClassCommodityInflation1> validate(RosettaPath path, T2 o, Set<String> fields) {
		Map<String, Boolean> fieldExistenceMap = ImmutableMap.<String, Boolean>builder()
				.put("basePdct", ExistenceChecker.isSet((AssetClassProductType12Code) o.getBasePdct()))
				.build();
		
		// Find the fields that are set
		Set<String> setFields = fieldExistenceMap.entrySet().stream()
				.filter(Map.Entry::getValue)
				.map(Map.Entry::getKey)
				.collect(Collectors.toSet());
		
		if (setFields.equals(fields)) {
			return success("AssetClassCommodityInflation1", ValidationResult.ValidationType.ONLY_EXISTS, "AssetClassCommodityInflation1", path, "");
		}
		return failure("AssetClassCommodityInflation1", ValidationResult.ValidationType.ONLY_EXISTS, "AssetClassCommodityInflation1", path, "",
				String.format("[%s] should only be set.  Set fields: %s", fields, setFields));
	}
}
