# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['TransferBase']


class TransferBase(BaseDataClass):
    identifier: List[AttributeWithMeta[cdm.base.staticdata.identifier.Identifier.Identifier] | cdm.base.staticdata.identifier.Identifier.Identifier] = Field([], description="Represents a unique reference to the transfer.")
    """
    Represents a unique reference to the transfer.
    """
    quantity: cdm.base.math.NonNegativeQuantity.NonNegativeQuantity = Field(..., description="Represents the amount of the asset to be transferred.")
    """
    Represents the amount of the asset to be transferred.
    """
    observable: Optional[cdm.observable.asset.Observable.Observable] = Field(None, description="Represents the object that is subject to the transfer, it could be an asset or a reference.")
    """
    Represents the object that is subject to the transfer, it could be an asset or a reference.
    """
    payerReceiver: cdm.base.staticdata.party.PartyReferencePayerReceiver.PartyReferencePayerReceiver = Field(..., description="Represents the parties to the transfer and their role.")
    """
    Represents the parties to the transfer and their role.
    """
    settlementDate: cdm.base.datetime.AdjustableOrAdjustedOrRelativeDate.AdjustableOrAdjustedOrRelativeDate = Field(..., description="Represents the date on which the transfer to due.")
    """
    Represents the date on which the transfer to due.
    """
    
    @rosetta_condition
    def condition_0_FinancialUnitExists(self):
        item = self
        def _then_fn0():
            return rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "quantity"), "unit"), "financialUnit"))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(self, "observable")), _then_fn0, _else_fn0)

import cdm 
import cdm.base.staticdata.identifier.Identifier
import cdm.base.math.NonNegativeQuantity
import cdm.observable.asset.Observable
import cdm.base.staticdata.party.PartyReferencePayerReceiver
import cdm.base.datetime.AdjustableOrAdjustedOrRelativeDate
