# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['MasterAgreementSchedule']


class MasterAgreementSchedule(BaseDataClass):
    """
    The set of elections which specify a Master Agreement.
    """
    clause: List[cdm.legaldocumentation.master.MasterAgreementClause.MasterAgreementClause] = Field([], description="Clauses that have had elections made against them in this Master Agreement. There must be at least one clause defined in the agreement.")
    """
    Clauses that have had elections made against them in this Master Agreement. There must be at least one clause defined in the agreement.
    """
    @rosetta_condition
    def cardinality_clause(self):
        return check_cardinality(self.clause, 1, None)
    

import cdm 
import cdm.legaldocumentation.master.MasterAgreementClause
