# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['CollateralCriteriaBase']


class CollateralCriteriaBase(BaseDataClass):
    """
    Represents a set of criteria used to specify and describe collateral.
    """
    issuer: List[cdm.product.collateral.IssuerCriteria.IssuerCriteria] = Field([], description="Represents a filter based criteria related to the issuer.")
    """
    Represents a filter based criteria related to the issuer.
    """
    asset: List[cdm.product.collateral.AssetCriteria.AssetCriteria] = Field([], description="Represents a filter based on the criteria related to the asset.")
    """
    Represents a filter based on the criteria related to the asset.
    """
    appliesTo: List[cdm.base.staticdata.party.CounterpartyRoleEnum.CounterpartyRoleEnum] = Field([], description="Specifies which of the two counterparties the criteria applies to (either one or both counterparties). This attribute is optional, in case the applicable party is already specified elsewhere within a party election.")
    """
    Specifies which of the two counterparties the criteria applies to (either one or both counterparties). This attribute is optional, in case the applicable party is already specified elsewhere within a party election.
    """

import cdm 
import cdm.product.collateral.IssuerCriteria
import cdm.product.collateral.AssetCriteria
import cdm.base.staticdata.party.CounterpartyRoleEnum
