# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['Basket']

from cdm.base.staticdata.asset.common.ProductBase import ProductBase

class Basket(ProductBase):
    """
    Defines a custom basket by referencing a product identifier and its consituents.
    """
    basketConstituent: List[cdm.product.template.Product.Product] = Field([], description="Identifies the constituents of the basket")
    """
    Identifies the constituents of the basket
    """
    portfolioBasketConstituent: List[cdm.product.template.BasketConstituent.BasketConstituent] = Field([], description="Identifies the constituents of the basket")
    """
    Identifies the constituents of the basket
    """
    
    @rosetta_condition
    def condition_0_(self):
        item = self
        return rosetta_check_one_of(self, 'basketConstituent', 'portfolioBasketConstituent', necessity=True)

import cdm 
import cdm.product.template.Product
import cdm.product.template.BasketConstituent
