/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.staticdata.asset.common.validation.datarule;

import cdm.base.staticdata.asset.common.Listing;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="ListingRelatedExchange")
@ImplementedBy(value=Default.class)
public interface ListingRelatedExchange
extends Validator<Listing> {
    public static final String NAME = "ListingRelatedExchange";
    public static final String DEFINITION = "if exchange is absent then relatedExchange is absent";

    public static class NoOp
    implements ListingRelatedExchange {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Listing listing) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements ListingRelatedExchange {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Listing listing) {
            ComparisonResult result = this.executeDataRule(listing);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)ListingRelatedExchange.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Listing", (RosettaPath)path, (String)ListingRelatedExchange.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)ListingRelatedExchange.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Listing", (RosettaPath)path, (String)ListingRelatedExchange.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(Listing listing) {
            try {
                if (ExpressionOperators.notExists((Mapper)MapperS.of((Object)listing).map("getExchange", _listing -> _listing.getExchange())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperators.notExists((Mapper)MapperS.of((Object)listing).mapC("getRelatedExchange", _listing -> _listing.getRelatedExchange()));
                }
                return ComparisonResult.successEmptyOperand((String)"");
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

