/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common;

import cdm.event.common.CollateralStatusEnum;
import cdm.event.common.TradeState;
import cdm.event.common.meta.CollateralPositionMeta;
import cdm.event.common.metafields.ReferenceWithMetaTradeState;
import cdm.event.position.Position;
import cdm.observable.asset.Money;
import cdm.product.collateral.CollateralTreatment;
import cdm.product.common.settlement.PriceQuantity;
import cdm.product.template.Product;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="CollateralPosition", builder=CollateralPositionBuilderImpl.class, version="5.30.0")
@RuneDataType(value="CollateralPosition", model="cdm", builder=CollateralPositionBuilderImpl.class, version="5.30.0")
public interface CollateralPosition
extends Position {
    public static final CollateralPositionMeta metaData = new CollateralPositionMeta();

    public CollateralTreatment getTreatment();

    public CollateralStatusEnum getCollateralPositionStatus();

    @Override
    public CollateralPosition build();

    @Override
    public CollateralPositionBuilder toBuilder();

    public static CollateralPositionBuilder builder() {
        return new CollateralPositionBuilderImpl();
    }

    default public RosettaMetaData<? extends CollateralPosition> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CollateralPosition> getType() {
        return CollateralPosition.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("priceQuantity"), processor, PriceQuantity.class, this.getPriceQuantity(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("product"), processor, Product.class, this.getProduct(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("cashBalance"), processor, Money.class, this.getCashBalance(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("tradeReference"), processor, ReferenceWithMetaTradeState.class, this.getTradeReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("treatment"), processor, CollateralTreatment.class, this.getTreatment(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("collateralPositionStatus"), CollateralStatusEnum.class, (Object)this.getCollateralPositionStatus(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class CollateralPositionBuilderImpl
    extends Position.PositionBuilderImpl
    implements CollateralPositionBuilder {
        protected CollateralTreatment.CollateralTreatmentBuilder treatment;
        protected CollateralStatusEnum collateralPositionStatus;

        @Override
        @RosettaAttribute(value="treatment")
        @RuneAttribute(value="treatment")
        public CollateralTreatment.CollateralTreatmentBuilder getTreatment() {
            return this.treatment;
        }

        @Override
        public CollateralTreatment.CollateralTreatmentBuilder getOrCreateTreatment() {
            CollateralTreatment.CollateralTreatmentBuilder result = this.treatment != null ? this.treatment : (this.treatment = CollateralTreatment.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="collateralPositionStatus")
        @RuneAttribute(value="collateralPositionStatus")
        public CollateralStatusEnum getCollateralPositionStatus() {
            return this.collateralPositionStatus;
        }

        @Override
        @RosettaAttribute(value="priceQuantity", isRequired=true)
        @RuneAttribute(value="priceQuantity", isRequired=true)
        public CollateralPositionBuilder addPriceQuantity(PriceQuantity _priceQuantity) {
            if (_priceQuantity != null) {
                this.priceQuantity.add(_priceQuantity.toBuilder());
            }
            return this;
        }

        @Override
        public CollateralPositionBuilder addPriceQuantity(PriceQuantity _priceQuantity, int idx) {
            this.getIndex(this.priceQuantity, idx, () -> _priceQuantity.toBuilder());
            return this;
        }

        @Override
        public CollateralPositionBuilder addPriceQuantity(List<? extends PriceQuantity> priceQuantitys) {
            if (priceQuantitys != null) {
                for (PriceQuantity priceQuantity : priceQuantitys) {
                    this.priceQuantity.add(priceQuantity.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="priceQuantity")
        public CollateralPositionBuilder setPriceQuantity(List<? extends PriceQuantity> priceQuantitys) {
            this.priceQuantity = priceQuantitys == null ? new ArrayList() : (List)priceQuantitys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="product", isRequired=true)
        @RuneAttribute(value="product", isRequired=true)
        public CollateralPositionBuilder setProduct(Product _product) {
            this.product = _product == null ? null : _product.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="cashBalance")
        @RuneAttribute(value="cashBalance")
        public CollateralPositionBuilder setCashBalance(Money _cashBalance) {
            this.cashBalance = _cashBalance == null ? null : _cashBalance.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeReference")
        @RuneAttribute(value="tradeReference")
        public CollateralPositionBuilder setTradeReference(ReferenceWithMetaTradeState _tradeReference) {
            this.tradeReference = _tradeReference == null ? null : _tradeReference.toBuilder();
            return this;
        }

        @Override
        public CollateralPositionBuilder setTradeReferenceValue(TradeState _tradeReference) {
            this.getOrCreateTradeReference().setValue(_tradeReference);
            return this;
        }

        @Override
        @RosettaAttribute(value="treatment")
        @RuneAttribute(value="treatment")
        public CollateralPositionBuilder setTreatment(CollateralTreatment _treatment) {
            this.treatment = _treatment == null ? null : _treatment.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="collateralPositionStatus")
        @RuneAttribute(value="collateralPositionStatus")
        public CollateralPositionBuilder setCollateralPositionStatus(CollateralStatusEnum _collateralPositionStatus) {
            this.collateralPositionStatus = _collateralPositionStatus == null ? null : _collateralPositionStatus;
            return this;
        }

        @Override
        public CollateralPosition build() {
            return new CollateralPositionImpl(this);
        }

        @Override
        public CollateralPositionBuilder toBuilder() {
            return this;
        }

        @Override
        public CollateralPositionBuilder prune() {
            super.prune();
            if (this.treatment != null && !this.treatment.prune().hasData()) {
                this.treatment = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getTreatment() != null && this.getTreatment().hasData()) {
                return true;
            }
            return this.getCollateralPositionStatus() != null;
        }

        @Override
        public CollateralPositionBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            CollateralPositionBuilder o = (CollateralPositionBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTreatment(), (RosettaModelObjectBuilder)o.getTreatment(), this::setTreatment);
            merger.mergeBasic((Object)this.getCollateralPositionStatus(), (Object)o.getCollateralPositionStatus(), this::setCollateralPositionStatus, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CollateralPosition _that = (CollateralPosition)this.getType().cast(o);
            if (!Objects.equals(this.treatment, _that.getTreatment())) {
                return false;
            }
            return Objects.equals((Object)this.collateralPositionStatus, (Object)_that.getCollateralPositionStatus());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.treatment != null ? this.treatment.hashCode() : 0);
            _result = 31 * _result + (this.collateralPositionStatus != null ? ((Object)((Object)this.collateralPositionStatus)).getClass().getName().hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CollateralPositionBuilder {treatment=" + this.treatment + ", collateralPositionStatus=" + (Object)((Object)this.collateralPositionStatus) + '}' + " " + super.toString();
        }
    }

    public static interface CollateralPositionBuilder
    extends CollateralPosition,
    Position.PositionBuilder {
        public CollateralTreatment.CollateralTreatmentBuilder getOrCreateTreatment();

        @Override
        public CollateralTreatment.CollateralTreatmentBuilder getTreatment();

        @Override
        public CollateralPositionBuilder addPriceQuantity(PriceQuantity var1);

        @Override
        public CollateralPositionBuilder addPriceQuantity(PriceQuantity var1, int var2);

        @Override
        public CollateralPositionBuilder addPriceQuantity(List<? extends PriceQuantity> var1);

        @Override
        public CollateralPositionBuilder setPriceQuantity(List<? extends PriceQuantity> var1);

        @Override
        public CollateralPositionBuilder setProduct(Product var1);

        @Override
        public CollateralPositionBuilder setCashBalance(Money var1);

        @Override
        public CollateralPositionBuilder setTradeReference(ReferenceWithMetaTradeState var1);

        @Override
        public CollateralPositionBuilder setTradeReferenceValue(TradeState var1);

        public CollateralPositionBuilder setTreatment(CollateralTreatment var1);

        public CollateralPositionBuilder setCollateralPositionStatus(CollateralStatusEnum var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("priceQuantity"), processor, PriceQuantity.PriceQuantityBuilder.class, this.getPriceQuantity(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("product"), processor, Product.ProductBuilder.class, (RosettaModelObjectBuilder)this.getProduct(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("cashBalance"), processor, Money.MoneyBuilder.class, (RosettaModelObjectBuilder)this.getCashBalance(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("tradeReference"), processor, ReferenceWithMetaTradeState.ReferenceWithMetaTradeStateBuilder.class, (RosettaModelObjectBuilder)this.getTradeReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("treatment"), processor, CollateralTreatment.CollateralTreatmentBuilder.class, this.getTreatment(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("collateralPositionStatus"), CollateralStatusEnum.class, (Object)this.getCollateralPositionStatus(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public CollateralPositionBuilder prune();
    }

    public static class CollateralPositionImpl
    extends Position.PositionImpl
    implements CollateralPosition {
        private final CollateralTreatment treatment;
        private final CollateralStatusEnum collateralPositionStatus;

        protected CollateralPositionImpl(CollateralPositionBuilder builder) {
            super(builder);
            this.treatment = Optional.ofNullable(builder.getTreatment()).map(f -> f.build()).orElse(null);
            this.collateralPositionStatus = builder.getCollateralPositionStatus();
        }

        @Override
        @RosettaAttribute(value="treatment")
        @RuneAttribute(value="treatment")
        public CollateralTreatment getTreatment() {
            return this.treatment;
        }

        @Override
        @RosettaAttribute(value="collateralPositionStatus")
        @RuneAttribute(value="collateralPositionStatus")
        public CollateralStatusEnum getCollateralPositionStatus() {
            return this.collateralPositionStatus;
        }

        @Override
        public CollateralPosition build() {
            return this;
        }

        @Override
        public CollateralPositionBuilder toBuilder() {
            CollateralPositionBuilder builder = CollateralPosition.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CollateralPositionBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getTreatment()).ifPresent(builder::setTreatment);
            Optional.ofNullable(this.getCollateralPositionStatus()).ifPresent(builder::setCollateralPositionStatus);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CollateralPosition _that = (CollateralPosition)this.getType().cast(o);
            if (!Objects.equals(this.treatment, _that.getTreatment())) {
                return false;
            }
            return Objects.equals((Object)this.collateralPositionStatus, (Object)_that.getCollateralPositionStatus());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.treatment != null ? this.treatment.hashCode() : 0);
            _result = 31 * _result + (this.collateralPositionStatus != null ? ((Object)((Object)this.collateralPositionStatus)).getClass().getName().hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CollateralPosition {treatment=" + this.treatment + ", collateralPositionStatus=" + (Object)((Object)this.collateralPositionStatus) + '}' + " " + super.toString();
        }
    }
}

