/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common;

import cdm.base.datetime.AdjustableOrAdjustedOrRelativeDate;
import cdm.base.math.NonNegativeQuantity;
import cdm.base.staticdata.identifier.Identifier;
import cdm.base.staticdata.identifier.metafields.FieldWithMetaIdentifier;
import cdm.base.staticdata.party.PartyReferencePayerReceiver;
import cdm.event.common.Reset;
import cdm.event.common.SettlementOrigin;
import cdm.event.common.TransferBase;
import cdm.event.common.TransferExpression;
import cdm.event.common.meta.TransferMeta;
import cdm.observable.asset.Observable;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="Transfer", builder=TransferBuilderImpl.class, version="5.30.0")
@RuneDataType(value="Transfer", model="cdm", builder=TransferBuilderImpl.class, version="5.30.0")
public interface Transfer
extends TransferBase {
    public static final TransferMeta metaData = new TransferMeta();

    public SettlementOrigin getSettlementOrigin();

    public Reset getResetOrigin();

    public TransferExpression getTransferExpression();

    @Override
    public Transfer build();

    @Override
    public TransferBuilder toBuilder();

    public static TransferBuilder builder() {
        return new TransferBuilderImpl();
    }

    default public RosettaMetaData<? extends Transfer> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Transfer> getType() {
        return Transfer.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("identifier"), processor, FieldWithMetaIdentifier.class, this.getIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("quantity"), processor, NonNegativeQuantity.class, this.getQuantity(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("observable"), processor, Observable.class, this.getObservable(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("payerReceiver"), processor, PartyReferencePayerReceiver.class, this.getPayerReceiver(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("settlementDate"), processor, AdjustableOrAdjustedOrRelativeDate.class, this.getSettlementDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("settlementOrigin"), processor, SettlementOrigin.class, this.getSettlementOrigin(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("resetOrigin"), processor, Reset.class, this.getResetOrigin(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("transferExpression"), processor, TransferExpression.class, this.getTransferExpression(), new AttributeMeta[0]);
    }

    public static class TransferBuilderImpl
    extends TransferBase.TransferBaseBuilderImpl
    implements TransferBuilder {
        protected SettlementOrigin.SettlementOriginBuilder settlementOrigin;
        protected Reset.ResetBuilder resetOrigin;
        protected TransferExpression.TransferExpressionBuilder transferExpression;

        @Override
        @RosettaAttribute(value="settlementOrigin")
        @RuneAttribute(value="settlementOrigin")
        public SettlementOrigin.SettlementOriginBuilder getSettlementOrigin() {
            return this.settlementOrigin;
        }

        @Override
        public SettlementOrigin.SettlementOriginBuilder getOrCreateSettlementOrigin() {
            SettlementOrigin.SettlementOriginBuilder result = this.settlementOrigin != null ? this.settlementOrigin : (this.settlementOrigin = SettlementOrigin.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="resetOrigin")
        @RuneAttribute(value="resetOrigin")
        public Reset.ResetBuilder getResetOrigin() {
            return this.resetOrigin;
        }

        @Override
        public Reset.ResetBuilder getOrCreateResetOrigin() {
            Reset.ResetBuilder result = this.resetOrigin != null ? this.resetOrigin : (this.resetOrigin = Reset.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="transferExpression", isRequired=true)
        @RuneAttribute(value="transferExpression", isRequired=true)
        public TransferExpression.TransferExpressionBuilder getTransferExpression() {
            return this.transferExpression;
        }

        @Override
        public TransferExpression.TransferExpressionBuilder getOrCreateTransferExpression() {
            TransferExpression.TransferExpressionBuilder result = this.transferExpression != null ? this.transferExpression : (this.transferExpression = TransferExpression.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="identifier")
        @RuneAttribute(value="identifier")
        public TransferBuilder addIdentifier(FieldWithMetaIdentifier _identifier) {
            if (_identifier != null) {
                this.identifier.add(_identifier.toBuilder());
            }
            return this;
        }

        @Override
        public TransferBuilder addIdentifier(FieldWithMetaIdentifier _identifier, int idx) {
            this.getIndex(this.identifier, idx, () -> _identifier.toBuilder());
            return this;
        }

        @Override
        public TransferBuilder addIdentifierValue(Identifier _identifier) {
            this.getOrCreateIdentifier(-1).setValue(_identifier.toBuilder());
            return this;
        }

        @Override
        public TransferBuilder addIdentifierValue(Identifier _identifier, int idx) {
            this.getOrCreateIdentifier(idx).setValue(_identifier.toBuilder());
            return this;
        }

        @Override
        public TransferBuilder addIdentifier(List<? extends FieldWithMetaIdentifier> identifiers) {
            if (identifiers != null) {
                for (FieldWithMetaIdentifier fieldWithMetaIdentifier : identifiers) {
                    this.identifier.add(fieldWithMetaIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="identifier")
        public TransferBuilder setIdentifier(List<? extends FieldWithMetaIdentifier> identifiers) {
            this.identifier = identifiers == null ? new ArrayList() : (List)identifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public TransferBuilder addIdentifierValue(List<? extends Identifier> identifiers) {
            if (identifiers != null) {
                for (Identifier identifier : identifiers) {
                    this.addIdentifierValue(identifier);
                }
            }
            return this;
        }

        @Override
        public TransferBuilder setIdentifierValue(List<? extends Identifier> identifiers) {
            this.identifier.clear();
            if (identifiers != null) {
                identifiers.forEach(this::addIdentifierValue);
            }
            return this;
        }

        @Override
        @RosettaAttribute(value="quantity", isRequired=true)
        @RuneAttribute(value="quantity", isRequired=true)
        public TransferBuilder setQuantity(NonNegativeQuantity _quantity) {
            this.quantity = _quantity == null ? null : _quantity.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="observable")
        @RuneAttribute(value="observable")
        public TransferBuilder setObservable(Observable _observable) {
            this.observable = _observable == null ? null : _observable.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="payerReceiver", isRequired=true)
        @RuneAttribute(value="payerReceiver", isRequired=true)
        public TransferBuilder setPayerReceiver(PartyReferencePayerReceiver _payerReceiver) {
            this.payerReceiver = _payerReceiver == null ? null : _payerReceiver.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementDate", isRequired=true)
        @RuneAttribute(value="settlementDate", isRequired=true)
        public TransferBuilder setSettlementDate(AdjustableOrAdjustedOrRelativeDate _settlementDate) {
            this.settlementDate = _settlementDate == null ? null : _settlementDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementOrigin")
        @RuneAttribute(value="settlementOrigin")
        public TransferBuilder setSettlementOrigin(SettlementOrigin _settlementOrigin) {
            this.settlementOrigin = _settlementOrigin == null ? null : _settlementOrigin.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="resetOrigin")
        @RuneAttribute(value="resetOrigin")
        public TransferBuilder setResetOrigin(Reset _resetOrigin) {
            this.resetOrigin = _resetOrigin == null ? null : _resetOrigin.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="transferExpression", isRequired=true)
        @RuneAttribute(value="transferExpression", isRequired=true)
        public TransferBuilder setTransferExpression(TransferExpression _transferExpression) {
            this.transferExpression = _transferExpression == null ? null : _transferExpression.toBuilder();
            return this;
        }

        @Override
        public Transfer build() {
            return new TransferImpl(this);
        }

        @Override
        public TransferBuilder toBuilder() {
            return this;
        }

        @Override
        public TransferBuilder prune() {
            super.prune();
            if (this.settlementOrigin != null && !this.settlementOrigin.prune().hasData()) {
                this.settlementOrigin = null;
            }
            if (this.resetOrigin != null && !this.resetOrigin.prune().hasData()) {
                this.resetOrigin = null;
            }
            if (this.transferExpression != null && !this.transferExpression.prune().hasData()) {
                this.transferExpression = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getSettlementOrigin() != null && this.getSettlementOrigin().hasData()) {
                return true;
            }
            if (this.getResetOrigin() != null && this.getResetOrigin().hasData()) {
                return true;
            }
            return this.getTransferExpression() != null && this.getTransferExpression().hasData();
        }

        @Override
        public TransferBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            TransferBuilder o = (TransferBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSettlementOrigin(), (RosettaModelObjectBuilder)o.getSettlementOrigin(), this::setSettlementOrigin);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getResetOrigin(), (RosettaModelObjectBuilder)o.getResetOrigin(), this::setResetOrigin);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTransferExpression(), (RosettaModelObjectBuilder)o.getTransferExpression(), this::setTransferExpression);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Transfer _that = (Transfer)this.getType().cast(o);
            if (!Objects.equals(this.settlementOrigin, _that.getSettlementOrigin())) {
                return false;
            }
            if (!Objects.equals(this.resetOrigin, _that.getResetOrigin())) {
                return false;
            }
            return Objects.equals(this.transferExpression, _that.getTransferExpression());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.settlementOrigin != null ? this.settlementOrigin.hashCode() : 0);
            _result = 31 * _result + (this.resetOrigin != null ? this.resetOrigin.hashCode() : 0);
            _result = 31 * _result + (this.transferExpression != null ? this.transferExpression.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "TransferBuilder {settlementOrigin=" + this.settlementOrigin + ", resetOrigin=" + this.resetOrigin + ", transferExpression=" + this.transferExpression + '}' + " " + super.toString();
        }
    }

    public static interface TransferBuilder
    extends Transfer,
    TransferBase.TransferBaseBuilder {
        public SettlementOrigin.SettlementOriginBuilder getOrCreateSettlementOrigin();

        @Override
        public SettlementOrigin.SettlementOriginBuilder getSettlementOrigin();

        public Reset.ResetBuilder getOrCreateResetOrigin();

        @Override
        public Reset.ResetBuilder getResetOrigin();

        public TransferExpression.TransferExpressionBuilder getOrCreateTransferExpression();

        @Override
        public TransferExpression.TransferExpressionBuilder getTransferExpression();

        @Override
        public TransferBuilder addIdentifier(FieldWithMetaIdentifier var1);

        @Override
        public TransferBuilder addIdentifier(FieldWithMetaIdentifier var1, int var2);

        @Override
        public TransferBuilder addIdentifierValue(Identifier var1);

        @Override
        public TransferBuilder addIdentifierValue(Identifier var1, int var2);

        @Override
        public TransferBuilder addIdentifier(List<? extends FieldWithMetaIdentifier> var1);

        @Override
        public TransferBuilder setIdentifier(List<? extends FieldWithMetaIdentifier> var1);

        @Override
        public TransferBuilder addIdentifierValue(List<? extends Identifier> var1);

        @Override
        public TransferBuilder setIdentifierValue(List<? extends Identifier> var1);

        @Override
        public TransferBuilder setQuantity(NonNegativeQuantity var1);

        @Override
        public TransferBuilder setObservable(Observable var1);

        @Override
        public TransferBuilder setPayerReceiver(PartyReferencePayerReceiver var1);

        @Override
        public TransferBuilder setSettlementDate(AdjustableOrAdjustedOrRelativeDate var1);

        public TransferBuilder setSettlementOrigin(SettlementOrigin var1);

        public TransferBuilder setResetOrigin(Reset var1);

        public TransferBuilder setTransferExpression(TransferExpression var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("identifier"), processor, FieldWithMetaIdentifier.FieldWithMetaIdentifierBuilder.class, this.getIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("quantity"), processor, NonNegativeQuantity.NonNegativeQuantityBuilder.class, (RosettaModelObjectBuilder)this.getQuantity(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("observable"), processor, Observable.ObservableBuilder.class, (RosettaModelObjectBuilder)this.getObservable(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("payerReceiver"), processor, PartyReferencePayerReceiver.PartyReferencePayerReceiverBuilder.class, (RosettaModelObjectBuilder)this.getPayerReceiver(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("settlementDate"), processor, AdjustableOrAdjustedOrRelativeDate.AdjustableOrAdjustedOrRelativeDateBuilder.class, (RosettaModelObjectBuilder)this.getSettlementDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("settlementOrigin"), processor, SettlementOrigin.SettlementOriginBuilder.class, this.getSettlementOrigin(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("resetOrigin"), processor, Reset.ResetBuilder.class, this.getResetOrigin(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("transferExpression"), processor, TransferExpression.TransferExpressionBuilder.class, this.getTransferExpression(), new AttributeMeta[0]);
        }

        @Override
        public TransferBuilder prune();
    }

    public static class TransferImpl
    extends TransferBase.TransferBaseImpl
    implements Transfer {
        private final SettlementOrigin settlementOrigin;
        private final Reset resetOrigin;
        private final TransferExpression transferExpression;

        protected TransferImpl(TransferBuilder builder) {
            super(builder);
            this.settlementOrigin = Optional.ofNullable(builder.getSettlementOrigin()).map(f -> f.build()).orElse(null);
            this.resetOrigin = Optional.ofNullable(builder.getResetOrigin()).map(f -> f.build()).orElse(null);
            this.transferExpression = Optional.ofNullable(builder.getTransferExpression()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="settlementOrigin")
        @RuneAttribute(value="settlementOrigin")
        public SettlementOrigin getSettlementOrigin() {
            return this.settlementOrigin;
        }

        @Override
        @RosettaAttribute(value="resetOrigin")
        @RuneAttribute(value="resetOrigin")
        public Reset getResetOrigin() {
            return this.resetOrigin;
        }

        @Override
        @RosettaAttribute(value="transferExpression", isRequired=true)
        @RuneAttribute(value="transferExpression", isRequired=true)
        public TransferExpression getTransferExpression() {
            return this.transferExpression;
        }

        @Override
        public Transfer build() {
            return this;
        }

        @Override
        public TransferBuilder toBuilder() {
            TransferBuilder builder = Transfer.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(TransferBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getSettlementOrigin()).ifPresent(builder::setSettlementOrigin);
            Optional.ofNullable(this.getResetOrigin()).ifPresent(builder::setResetOrigin);
            Optional.ofNullable(this.getTransferExpression()).ifPresent(builder::setTransferExpression);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Transfer _that = (Transfer)this.getType().cast(o);
            if (!Objects.equals(this.settlementOrigin, _that.getSettlementOrigin())) {
                return false;
            }
            if (!Objects.equals(this.resetOrigin, _that.getResetOrigin())) {
                return false;
            }
            return Objects.equals(this.transferExpression, _that.getTransferExpression());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.settlementOrigin != null ? this.settlementOrigin.hashCode() : 0);
            _result = 31 * _result + (this.resetOrigin != null ? this.resetOrigin.hashCode() : 0);
            _result = 31 * _result + (this.transferExpression != null ? this.transferExpression.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "Transfer {settlementOrigin=" + this.settlementOrigin + ", resetOrigin=" + this.resetOrigin + ", transferExpression=" + this.transferExpression + '}' + " " + super.toString();
        }
    }
}

