/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset.validation.datarule;

import cdm.observable.asset.PriceSchedule;
import cdm.observable.asset.PriceTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="PriceSchedulePositiveSpotRate")
@ImplementedBy(value=Default.class)
public interface PriceSchedulePositiveSpotRate
extends Validator<PriceSchedule> {
    public static final String NAME = "PriceSchedulePositiveSpotRate";
    public static final String DEFINITION = "if (priceType = PriceTypeEnum -> ExchangeRate or priceType = PriceTypeEnum -> AssetPrice) and composite -> baseValue exists then composite -> baseValue > 0";

    public static class NoOp
    implements PriceSchedulePositiveSpotRate {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, PriceSchedule priceSchedule) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements PriceSchedulePositiveSpotRate {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, PriceSchedule priceSchedule) {
            ComparisonResult result = this.executeDataRule(priceSchedule);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)PriceSchedulePositiveSpotRate.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PriceSchedule", (RosettaPath)path, (String)PriceSchedulePositiveSpotRate.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)PriceSchedulePositiveSpotRate.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PriceSchedule", (RosettaPath)path, (String)PriceSchedulePositiveSpotRate.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(PriceSchedule priceSchedule) {
            try {
                if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)priceSchedule).map("getPriceType", _priceSchedule -> _priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)((Object)PriceTypeEnum.EXCHANGE_RATE)), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)priceSchedule).map("getPriceType", _priceSchedule -> _priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)((Object)PriceTypeEnum.ASSET_PRICE)), (CardinalityOperator)CardinalityOperator.All)).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)priceSchedule).map("getComposite", _priceSchedule -> _priceSchedule.getComposite()).map("getBaseValue", priceComposite -> priceComposite.getBaseValue()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperators.greaterThan((Mapper)MapperS.of((Object)priceSchedule).map("getComposite", _priceSchedule -> _priceSchedule.getComposite()).map("getBaseValue", priceComposite -> priceComposite.getBaseValue()), (Mapper)MapperS.of((Object)BigDecimal.valueOf(0L)), (CardinalityOperator)CardinalityOperator.All);
                }
                return ComparisonResult.successEmptyOperand((String)"");
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

