/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset;

import cdm.product.asset.AssetDeliveryProfile;
import cdm.product.asset.meta.AssetDeliveryPeriodsMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="AssetDeliveryPeriods", builder=AssetDeliveryPeriodsBuilderImpl.class, version="5.30.0")
@RuneDataType(value="AssetDeliveryPeriods", model="cdm", builder=AssetDeliveryPeriodsBuilderImpl.class, version="5.30.0")
public interface AssetDeliveryPeriods
extends RosettaModelObject {
    public static final AssetDeliveryPeriodsMeta metaData = new AssetDeliveryPeriodsMeta();

    public List<? extends AssetDeliveryProfile> getProfile();

    public Date getStartDate();

    public Date getEndDate();

    public AssetDeliveryPeriods build();

    public AssetDeliveryPeriodsBuilder toBuilder();

    public static AssetDeliveryPeriodsBuilder builder() {
        return new AssetDeliveryPeriodsBuilderImpl();
    }

    default public RosettaMetaData<? extends AssetDeliveryPeriods> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends AssetDeliveryPeriods> getType() {
        return AssetDeliveryPeriods.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("profile"), processor, AssetDeliveryProfile.class, this.getProfile(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("startDate"), Date.class, (Object)this.getStartDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("endDate"), Date.class, (Object)this.getEndDate(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class AssetDeliveryPeriodsBuilderImpl
    implements AssetDeliveryPeriodsBuilder {
        protected List<AssetDeliveryProfile.AssetDeliveryProfileBuilder> profile = new ArrayList<AssetDeliveryProfile.AssetDeliveryProfileBuilder>();
        protected Date startDate;
        protected Date endDate;

        @Override
        @RosettaAttribute(value="profile")
        @RuneAttribute(value="profile")
        public List<? extends AssetDeliveryProfile.AssetDeliveryProfileBuilder> getProfile() {
            return this.profile;
        }

        @Override
        public AssetDeliveryProfile.AssetDeliveryProfileBuilder getOrCreateProfile(int index) {
            if (this.profile == null) {
                this.profile = new ArrayList<AssetDeliveryProfile.AssetDeliveryProfileBuilder>();
            }
            return (AssetDeliveryProfile.AssetDeliveryProfileBuilder)this.getIndex(this.profile, index, () -> {
                AssetDeliveryProfile.AssetDeliveryProfileBuilder newProfile = AssetDeliveryProfile.builder();
                return newProfile;
            });
        }

        @Override
        @RosettaAttribute(value="startDate")
        @RuneAttribute(value="startDate")
        public Date getStartDate() {
            return this.startDate;
        }

        @Override
        @RosettaAttribute(value="endDate")
        @RuneAttribute(value="endDate")
        public Date getEndDate() {
            return this.endDate;
        }

        @Override
        @RosettaAttribute(value="profile")
        @RuneAttribute(value="profile")
        public AssetDeliveryPeriodsBuilder addProfile(AssetDeliveryProfile _profile) {
            if (_profile != null) {
                this.profile.add(_profile.toBuilder());
            }
            return this;
        }

        @Override
        public AssetDeliveryPeriodsBuilder addProfile(AssetDeliveryProfile _profile, int idx) {
            this.getIndex(this.profile, idx, () -> _profile.toBuilder());
            return this;
        }

        @Override
        public AssetDeliveryPeriodsBuilder addProfile(List<? extends AssetDeliveryProfile> profiles) {
            if (profiles != null) {
                for (AssetDeliveryProfile assetDeliveryProfile : profiles) {
                    this.profile.add(assetDeliveryProfile.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="profile")
        public AssetDeliveryPeriodsBuilder setProfile(List<? extends AssetDeliveryProfile> profiles) {
            this.profile = profiles == null ? new ArrayList<AssetDeliveryProfile.AssetDeliveryProfileBuilder>() : (List)profiles.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="startDate")
        @RuneAttribute(value="startDate")
        public AssetDeliveryPeriodsBuilder setStartDate(Date _startDate) {
            this.startDate = _startDate == null ? null : _startDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="endDate")
        @RuneAttribute(value="endDate")
        public AssetDeliveryPeriodsBuilder setEndDate(Date _endDate) {
            this.endDate = _endDate == null ? null : _endDate;
            return this;
        }

        @Override
        public AssetDeliveryPeriods build() {
            return new AssetDeliveryPeriodsImpl(this);
        }

        @Override
        public AssetDeliveryPeriodsBuilder toBuilder() {
            return this;
        }

        @Override
        public AssetDeliveryPeriodsBuilder prune() {
            this.profile = this.profile.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getProfile() != null && this.getProfile().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getStartDate() != null) {
                return true;
            }
            return this.getEndDate() != null;
        }

        public AssetDeliveryPeriodsBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            AssetDeliveryPeriodsBuilder o = (AssetDeliveryPeriodsBuilder)other;
            merger.mergeRosetta(this.getProfile(), o.getProfile(), this::getOrCreateProfile);
            merger.mergeBasic((Object)this.getStartDate(), (Object)o.getStartDate(), this::setStartDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getEndDate(), (Object)o.getEndDate(), this::setEndDate, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AssetDeliveryPeriods _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.profile, _that.getProfile())) {
                return false;
            }
            if (!Objects.equals(this.startDate, _that.getStartDate())) {
                return false;
            }
            return Objects.equals(this.endDate, _that.getEndDate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.profile != null ? this.profile.hashCode() : 0);
            _result = 31 * _result + (this.startDate != null ? this.startDate.hashCode() : 0);
            _result = 31 * _result + (this.endDate != null ? this.endDate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AssetDeliveryPeriodsBuilder {profile=" + this.profile + ", startDate=" + this.startDate + ", endDate=" + this.endDate + '}';
        }
    }

    public static interface AssetDeliveryPeriodsBuilder
    extends AssetDeliveryPeriods,
    RosettaModelObjectBuilder {
        public AssetDeliveryProfile.AssetDeliveryProfileBuilder getOrCreateProfile(int var1);

        public List<? extends AssetDeliveryProfile.AssetDeliveryProfileBuilder> getProfile();

        public AssetDeliveryPeriodsBuilder addProfile(AssetDeliveryProfile var1);

        public AssetDeliveryPeriodsBuilder addProfile(AssetDeliveryProfile var1, int var2);

        public AssetDeliveryPeriodsBuilder addProfile(List<? extends AssetDeliveryProfile> var1);

        public AssetDeliveryPeriodsBuilder setProfile(List<? extends AssetDeliveryProfile> var1);

        public AssetDeliveryPeriodsBuilder setStartDate(Date var1);

        public AssetDeliveryPeriodsBuilder setEndDate(Date var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("profile"), processor, AssetDeliveryProfile.AssetDeliveryProfileBuilder.class, this.getProfile(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("startDate"), Date.class, (Object)this.getStartDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("endDate"), Date.class, (Object)this.getEndDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public AssetDeliveryPeriodsBuilder prune();
    }

    public static class AssetDeliveryPeriodsImpl
    implements AssetDeliveryPeriods {
        private final List<? extends AssetDeliveryProfile> profile;
        private final Date startDate;
        private final Date endDate;

        protected AssetDeliveryPeriodsImpl(AssetDeliveryPeriodsBuilder builder) {
            this.profile = Optional.ofNullable(builder.getProfile()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.startDate = builder.getStartDate();
            this.endDate = builder.getEndDate();
        }

        @Override
        @RosettaAttribute(value="profile")
        @RuneAttribute(value="profile")
        public List<? extends AssetDeliveryProfile> getProfile() {
            return this.profile;
        }

        @Override
        @RosettaAttribute(value="startDate")
        @RuneAttribute(value="startDate")
        public Date getStartDate() {
            return this.startDate;
        }

        @Override
        @RosettaAttribute(value="endDate")
        @RuneAttribute(value="endDate")
        public Date getEndDate() {
            return this.endDate;
        }

        @Override
        public AssetDeliveryPeriods build() {
            return this;
        }

        @Override
        public AssetDeliveryPeriodsBuilder toBuilder() {
            AssetDeliveryPeriodsBuilder builder = AssetDeliveryPeriods.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AssetDeliveryPeriodsBuilder builder) {
            Optional.ofNullable(this.getProfile()).ifPresent(builder::setProfile);
            Optional.ofNullable(this.getStartDate()).ifPresent(builder::setStartDate);
            Optional.ofNullable(this.getEndDate()).ifPresent(builder::setEndDate);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AssetDeliveryPeriods _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.profile, _that.getProfile())) {
                return false;
            }
            if (!Objects.equals(this.startDate, _that.getStartDate())) {
                return false;
            }
            return Objects.equals(this.endDate, _that.getEndDate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.profile != null ? this.profile.hashCode() : 0);
            _result = 31 * _result + (this.startDate != null ? this.startDate.hashCode() : 0);
            _result = 31 * _result + (this.endDate != null ? this.endDate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AssetDeliveryPeriods {profile=" + this.profile + ", startDate=" + this.startDate + ", endDate=" + this.endDate + '}';
        }
    }
}

