/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.collateral;

import cdm.base.math.QuantifierEnum;
import cdm.observable.asset.CreditNotation;
import cdm.observable.asset.CreditNotationBoundaryEnum;
import cdm.observable.asset.CreditNotationMismatchResolutionEnum;
import cdm.observable.asset.CreditRatingAgencyEnum;
import cdm.product.collateral.meta.AgencyRatingCriteriaMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="AgencyRatingCriteria", builder=AgencyRatingCriteriaBuilderImpl.class, version="5.30.0")
@RuneDataType(value="AgencyRatingCriteria", model="cdm", builder=AgencyRatingCriteriaBuilderImpl.class, version="5.30.0")
public interface AgencyRatingCriteria
extends RosettaModelObject {
    public static final AgencyRatingCriteriaMeta metaData = new AgencyRatingCriteriaMeta();

    public QuantifierEnum getQualifier();

    public List<? extends CreditNotation> getCreditNotation();

    public CreditNotationMismatchResolutionEnum getMismatchResolution();

    public CreditRatingAgencyEnum getReferenceAgency();

    public CreditNotationBoundaryEnum getBoundary();

    public AgencyRatingCriteria build();

    public AgencyRatingCriteriaBuilder toBuilder();

    public static AgencyRatingCriteriaBuilder builder() {
        return new AgencyRatingCriteriaBuilderImpl();
    }

    default public RosettaMetaData<? extends AgencyRatingCriteria> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends AgencyRatingCriteria> getType() {
        return AgencyRatingCriteria.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("qualifier"), QuantifierEnum.class, (Object)this.getQualifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("creditNotation"), processor, CreditNotation.class, this.getCreditNotation(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("mismatchResolution"), CreditNotationMismatchResolutionEnum.class, (Object)this.getMismatchResolution(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("referenceAgency"), CreditRatingAgencyEnum.class, (Object)this.getReferenceAgency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("boundary"), CreditNotationBoundaryEnum.class, (Object)this.getBoundary(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class AgencyRatingCriteriaBuilderImpl
    implements AgencyRatingCriteriaBuilder {
        protected QuantifierEnum qualifier;
        protected List<CreditNotation.CreditNotationBuilder> creditNotation = new ArrayList<CreditNotation.CreditNotationBuilder>();
        protected CreditNotationMismatchResolutionEnum mismatchResolution;
        protected CreditRatingAgencyEnum referenceAgency;
        protected CreditNotationBoundaryEnum boundary;

        @Override
        @RosettaAttribute(value="qualifier", isRequired=true)
        @RuneAttribute(value="qualifier", isRequired=true)
        public QuantifierEnum getQualifier() {
            return this.qualifier;
        }

        @Override
        @RosettaAttribute(value="creditNotation", isRequired=true)
        @RuneAttribute(value="creditNotation", isRequired=true)
        public List<? extends CreditNotation.CreditNotationBuilder> getCreditNotation() {
            return this.creditNotation;
        }

        @Override
        public CreditNotation.CreditNotationBuilder getOrCreateCreditNotation(int index) {
            if (this.creditNotation == null) {
                this.creditNotation = new ArrayList<CreditNotation.CreditNotationBuilder>();
            }
            return (CreditNotation.CreditNotationBuilder)this.getIndex(this.creditNotation, index, () -> {
                CreditNotation.CreditNotationBuilder newCreditNotation = CreditNotation.builder();
                return newCreditNotation;
            });
        }

        @Override
        @RosettaAttribute(value="mismatchResolution")
        @RuneAttribute(value="mismatchResolution")
        public CreditNotationMismatchResolutionEnum getMismatchResolution() {
            return this.mismatchResolution;
        }

        @Override
        @RosettaAttribute(value="referenceAgency")
        @RuneAttribute(value="referenceAgency")
        public CreditRatingAgencyEnum getReferenceAgency() {
            return this.referenceAgency;
        }

        @Override
        @RosettaAttribute(value="boundary")
        @RuneAttribute(value="boundary")
        public CreditNotationBoundaryEnum getBoundary() {
            return this.boundary;
        }

        @Override
        @RosettaAttribute(value="qualifier", isRequired=true)
        @RuneAttribute(value="qualifier", isRequired=true)
        public AgencyRatingCriteriaBuilder setQualifier(QuantifierEnum _qualifier) {
            this.qualifier = _qualifier == null ? null : _qualifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="creditNotation", isRequired=true)
        @RuneAttribute(value="creditNotation", isRequired=true)
        public AgencyRatingCriteriaBuilder addCreditNotation(CreditNotation _creditNotation) {
            if (_creditNotation != null) {
                this.creditNotation.add(_creditNotation.toBuilder());
            }
            return this;
        }

        @Override
        public AgencyRatingCriteriaBuilder addCreditNotation(CreditNotation _creditNotation, int idx) {
            this.getIndex(this.creditNotation, idx, () -> _creditNotation.toBuilder());
            return this;
        }

        @Override
        public AgencyRatingCriteriaBuilder addCreditNotation(List<? extends CreditNotation> creditNotations) {
            if (creditNotations != null) {
                for (CreditNotation creditNotation : creditNotations) {
                    this.creditNotation.add(creditNotation.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="creditNotation")
        public AgencyRatingCriteriaBuilder setCreditNotation(List<? extends CreditNotation> creditNotations) {
            this.creditNotation = creditNotations == null ? new ArrayList<CreditNotation.CreditNotationBuilder>() : (List)creditNotations.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="mismatchResolution")
        @RuneAttribute(value="mismatchResolution")
        public AgencyRatingCriteriaBuilder setMismatchResolution(CreditNotationMismatchResolutionEnum _mismatchResolution) {
            this.mismatchResolution = _mismatchResolution == null ? null : _mismatchResolution;
            return this;
        }

        @Override
        @RosettaAttribute(value="referenceAgency")
        @RuneAttribute(value="referenceAgency")
        public AgencyRatingCriteriaBuilder setReferenceAgency(CreditRatingAgencyEnum _referenceAgency) {
            this.referenceAgency = _referenceAgency == null ? null : _referenceAgency;
            return this;
        }

        @Override
        @RosettaAttribute(value="boundary")
        @RuneAttribute(value="boundary")
        public AgencyRatingCriteriaBuilder setBoundary(CreditNotationBoundaryEnum _boundary) {
            this.boundary = _boundary == null ? null : _boundary;
            return this;
        }

        @Override
        public AgencyRatingCriteria build() {
            return new AgencyRatingCriteriaImpl(this);
        }

        @Override
        public AgencyRatingCriteriaBuilder toBuilder() {
            return this;
        }

        @Override
        public AgencyRatingCriteriaBuilder prune() {
            this.creditNotation = this.creditNotation.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getQualifier() != null) {
                return true;
            }
            if (this.getCreditNotation() != null && this.getCreditNotation().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getMismatchResolution() != null) {
                return true;
            }
            if (this.getReferenceAgency() != null) {
                return true;
            }
            return this.getBoundary() != null;
        }

        public AgencyRatingCriteriaBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            AgencyRatingCriteriaBuilder o = (AgencyRatingCriteriaBuilder)other;
            merger.mergeRosetta(this.getCreditNotation(), o.getCreditNotation(), this::getOrCreateCreditNotation);
            merger.mergeBasic((Object)this.getQualifier(), (Object)o.getQualifier(), this::setQualifier, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getMismatchResolution(), (Object)o.getMismatchResolution(), this::setMismatchResolution, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getReferenceAgency(), (Object)o.getReferenceAgency(), this::setReferenceAgency, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getBoundary(), (Object)o.getBoundary(), this::setBoundary, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AgencyRatingCriteria _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.qualifier, (Object)_that.getQualifier())) {
                return false;
            }
            if (!ListEquals.listEquals(this.creditNotation, _that.getCreditNotation())) {
                return false;
            }
            if (!Objects.equals((Object)this.mismatchResolution, (Object)_that.getMismatchResolution())) {
                return false;
            }
            if (!Objects.equals((Object)this.referenceAgency, (Object)_that.getReferenceAgency())) {
                return false;
            }
            return Objects.equals((Object)this.boundary, (Object)_that.getBoundary());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.qualifier != null ? ((Object)((Object)this.qualifier)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.creditNotation != null ? this.creditNotation.hashCode() : 0);
            _result = 31 * _result + (this.mismatchResolution != null ? ((Object)((Object)this.mismatchResolution)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.referenceAgency != null ? ((Object)((Object)this.referenceAgency)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.boundary != null ? ((Object)((Object)this.boundary)).getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AgencyRatingCriteriaBuilder {qualifier=" + (Object)((Object)this.qualifier) + ", creditNotation=" + this.creditNotation + ", mismatchResolution=" + (Object)((Object)this.mismatchResolution) + ", referenceAgency=" + (Object)((Object)this.referenceAgency) + ", boundary=" + (Object)((Object)this.boundary) + '}';
        }
    }

    public static interface AgencyRatingCriteriaBuilder
    extends AgencyRatingCriteria,
    RosettaModelObjectBuilder {
        public CreditNotation.CreditNotationBuilder getOrCreateCreditNotation(int var1);

        public List<? extends CreditNotation.CreditNotationBuilder> getCreditNotation();

        public AgencyRatingCriteriaBuilder setQualifier(QuantifierEnum var1);

        public AgencyRatingCriteriaBuilder addCreditNotation(CreditNotation var1);

        public AgencyRatingCriteriaBuilder addCreditNotation(CreditNotation var1, int var2);

        public AgencyRatingCriteriaBuilder addCreditNotation(List<? extends CreditNotation> var1);

        public AgencyRatingCriteriaBuilder setCreditNotation(List<? extends CreditNotation> var1);

        public AgencyRatingCriteriaBuilder setMismatchResolution(CreditNotationMismatchResolutionEnum var1);

        public AgencyRatingCriteriaBuilder setReferenceAgency(CreditRatingAgencyEnum var1);

        public AgencyRatingCriteriaBuilder setBoundary(CreditNotationBoundaryEnum var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("qualifier"), QuantifierEnum.class, (Object)this.getQualifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("creditNotation"), processor, CreditNotation.CreditNotationBuilder.class, this.getCreditNotation(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("mismatchResolution"), CreditNotationMismatchResolutionEnum.class, (Object)this.getMismatchResolution(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("referenceAgency"), CreditRatingAgencyEnum.class, (Object)this.getReferenceAgency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("boundary"), CreditNotationBoundaryEnum.class, (Object)this.getBoundary(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public AgencyRatingCriteriaBuilder prune();
    }

    public static class AgencyRatingCriteriaImpl
    implements AgencyRatingCriteria {
        private final QuantifierEnum qualifier;
        private final List<? extends CreditNotation> creditNotation;
        private final CreditNotationMismatchResolutionEnum mismatchResolution;
        private final CreditRatingAgencyEnum referenceAgency;
        private final CreditNotationBoundaryEnum boundary;

        protected AgencyRatingCriteriaImpl(AgencyRatingCriteriaBuilder builder) {
            this.qualifier = builder.getQualifier();
            this.creditNotation = Optional.ofNullable(builder.getCreditNotation()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.mismatchResolution = builder.getMismatchResolution();
            this.referenceAgency = builder.getReferenceAgency();
            this.boundary = builder.getBoundary();
        }

        @Override
        @RosettaAttribute(value="qualifier", isRequired=true)
        @RuneAttribute(value="qualifier", isRequired=true)
        public QuantifierEnum getQualifier() {
            return this.qualifier;
        }

        @Override
        @RosettaAttribute(value="creditNotation", isRequired=true)
        @RuneAttribute(value="creditNotation", isRequired=true)
        public List<? extends CreditNotation> getCreditNotation() {
            return this.creditNotation;
        }

        @Override
        @RosettaAttribute(value="mismatchResolution")
        @RuneAttribute(value="mismatchResolution")
        public CreditNotationMismatchResolutionEnum getMismatchResolution() {
            return this.mismatchResolution;
        }

        @Override
        @RosettaAttribute(value="referenceAgency")
        @RuneAttribute(value="referenceAgency")
        public CreditRatingAgencyEnum getReferenceAgency() {
            return this.referenceAgency;
        }

        @Override
        @RosettaAttribute(value="boundary")
        @RuneAttribute(value="boundary")
        public CreditNotationBoundaryEnum getBoundary() {
            return this.boundary;
        }

        @Override
        public AgencyRatingCriteria build() {
            return this;
        }

        @Override
        public AgencyRatingCriteriaBuilder toBuilder() {
            AgencyRatingCriteriaBuilder builder = AgencyRatingCriteria.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AgencyRatingCriteriaBuilder builder) {
            Optional.ofNullable(this.getQualifier()).ifPresent(builder::setQualifier);
            Optional.ofNullable(this.getCreditNotation()).ifPresent(builder::setCreditNotation);
            Optional.ofNullable(this.getMismatchResolution()).ifPresent(builder::setMismatchResolution);
            Optional.ofNullable(this.getReferenceAgency()).ifPresent(builder::setReferenceAgency);
            Optional.ofNullable(this.getBoundary()).ifPresent(builder::setBoundary);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AgencyRatingCriteria _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.qualifier, (Object)_that.getQualifier())) {
                return false;
            }
            if (!ListEquals.listEquals(this.creditNotation, _that.getCreditNotation())) {
                return false;
            }
            if (!Objects.equals((Object)this.mismatchResolution, (Object)_that.getMismatchResolution())) {
                return false;
            }
            if (!Objects.equals((Object)this.referenceAgency, (Object)_that.getReferenceAgency())) {
                return false;
            }
            return Objects.equals((Object)this.boundary, (Object)_that.getBoundary());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.qualifier != null ? ((Object)((Object)this.qualifier)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.creditNotation != null ? this.creditNotation.hashCode() : 0);
            _result = 31 * _result + (this.mismatchResolution != null ? ((Object)((Object)this.mismatchResolution)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.referenceAgency != null ? ((Object)((Object)this.referenceAgency)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.boundary != null ? ((Object)((Object)this.boundary)).getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AgencyRatingCriteria {qualifier=" + (Object)((Object)this.qualifier) + ", creditNotation=" + this.creditNotation + ", mismatchResolution=" + (Object)((Object)this.mismatchResolution) + ", referenceAgency=" + (Object)((Object)this.referenceAgency) + ", boundary=" + (Object)((Object)this.boundary) + '}';
        }
    }
}

